/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.cf.common.utils;

import dev.comfast.cf.CfApi;
import dev.comfast.util.TempFile;
import java.io.FileNotFoundException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.intellij.lang.annotations.Language;

public class BrowserContent {
    public void openResourceFile(String resourcePath) {
        URL resource = this.getClass().getClassLoader().getResource(resourcePath);
        if (resource == null) {
            throw new FileNotFoundException("Resource not found: " + resourcePath);
        }
        TempFile tempFile = new TempFile("comfast-unit-tests/" + resourcePath);
        tempFile.write(Files.readString(Path.of(resource.toURI()), StandardCharsets.UTF_8));
        CfApi.open(tempFile.file.toUri().toURL().toString());
    }

    public BrowserContent setStyle(@Language(value="CSS") String styleContent) {
        CfApi.executeJs("document.querySelector('html>head').innerHTML = arguments[0]", "<style>" + styleContent + "</style>");
        return this;
    }

    public BrowserContent setBody(@Language(value="HTML") String bodyHtml) {
        CfApi.executeJs("document.querySelector('html>body').innerHTML = arguments[0]", bodyHtml);
        return this;
    }

    public BrowserContent addJsTools() {
        this.setScriptTag("const $$ = (css, parent = document) => Array.from(parent.querySelectorAll(css));\nconst $ =  (css, parent = document) => parent.querySelector(css);\n");
        return this;
    }

    public BrowserContent setScriptTag(@Language(value="JavaScript") String scriptContent) {
        String escapedScriptContent = scriptContent.replace("`", "\\`");
        String ADD_SCRIPT = "const s = document.createElement('script');s.innerHTML = `" + escapedScriptContent + "`; document.querySelector('head').append(s);";
        CfApi.executeJs(ADD_SCRIPT, new Object[0]);
        return this;
    }

    public void clearAll() {
        CfApi.executeJs("document.querySelector('html').innerHTML = ''", new Object[0]);
    }
}

