/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.cf.se;

import dev.comfast.cf.common.errors.CfFrameworkError;
import dev.comfast.cf.common.errors.ElementFindFail;
import dev.comfast.cf.common.selector.SelectorChain;
import dev.comfast.cf.common.selector.SelectorParser;
import dev.comfast.cf.se.Finder;
import dev.comfast.cf.se.infra.DriverSource;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class WebElementFinder
implements Finder<WebElement> {
    private final SelectorChain chain;

    @Override
    public WebElement find() {
        return this.doFind(true, this.chain.split());
    }

    @Override
    public List<WebElement> findAll() {
        String[] selectors = this.chain.split();
        if (selectors.length == 0) {
            throw new CfFrameworkError("Empty chain, require at least 1 item", new Object[0]);
        }
        By lastBy = this.string2By(selectors[selectors.length - 1]);
        if (selectors.length == 1) {
            return DriverSource.getDriver().findElements(lastBy);
        }
        String[] parents = Arrays.copyOf(selectors, selectors.length - 1);
        WebElement parent = this.doFind(false, parents);
        return parent == null ? List.of() : parent.findElements(lastBy);
    }

    private WebElement doFind(boolean throwIfNotFound, String ... selectors) {
        int i = 0;
        try {
            WebElement currentEl = DriverSource.getDriver().findElement(this.string2By(selectors[i]));
            for (i = 1; i < selectors.length; ++i) {
                currentEl = this.findChild((SearchContext)currentEl, this.string2By(selectors[i]));
            }
            return currentEl;
        }
        catch (InvalidArgumentException | InvalidSelectorException | NoSuchElementException ex) {
            if (!throwIfNotFound) {
                return null;
            }
            throw new ElementFindFail(this.chain, i, ex);
        }
    }

    private By string2By(String selector) {
        return SelectorParser.isXpath(selector) ? By.xpath((String)selector) : By.cssSelector((String)selector);
    }

    private WebElement findChild(SearchContext parent, By by) {
        try {
            return parent.findElement(by);
        }
        catch (NoSuchElementException ex) {
            SearchContext shadowRoot = (SearchContext)DriverSource.getDriver().executeScript("return arguments[0].shadowRoot", new Object[]{parent});
            if (shadowRoot != null) {
                return shadowRoot.findElement(by);
            }
            throw ex;
        }
    }

    public WebElementFinder(SelectorChain chain) {
        this.chain = chain;
    }
}

