/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.util.time;

import dev.comfast.rgx.RgxApi;
import dev.comfast.rgx.RgxMatch;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.Duration;

public class TimeFormatter {
    public String formatDuration(Duration duration) {
        if (duration.toSeconds() < 60L) {
            return this.formatNanoseconds(duration.toNanos());
        }
        String result = duration.toString().replaceFirst("^PT", "").replaceAll("([H|M])", "$1 ").trim().toLowerCase();
        RgxMatch match = RgxApi.rgx("(\\d\\.\\d+)s$").match(result);
        if (match.isPresent()) {
            String formattedSeconds = this.roundNumber(1, Double.parseDouble(match.get(1)));
            return result.replaceFirst(match.get() + "$", formattedSeconds) + "s";
        }
        return result;
    }

    public String formatNanoseconds(long nanos) {
        if (nanos < 1000L) {
            return this.roundNumber(nanos) + "ns";
        }
        if (nanos < 1000000L) {
            return this.roundNumber((double)nanos / 1000.0) + "\u00b5s";
        }
        if (nanos < 1000000000L) {
            return this.roundNumber((double)nanos / 1000000.0) + "ms";
        }
        return this.roundNumber((double)nanos / 1.0E9) + "s";
    }

    private String roundNumber(double input) {
        return this.roundNumber(3, input);
    }

    private String roundNumber(int significantDigits, double input) {
        return new BigDecimal(input).round(new MathContext(significantDigits, RoundingMode.HALF_EVEN)).stripTrailingZeros().toPlainString();
    }
}

