/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class TempFile {
    public final Path file;
    public final boolean autoRemove;

    public TempFile(String tmpPath) {
        this(tmpPath, false);
    }

    public TempFile(String tmpPath, boolean autoRemove) {
        this.file = Path.of(System.getProperty("java.io.tmpdir"), tmpPath);
        this.autoRemove = autoRemove;
        if (autoRemove) {
            Runtime.getRuntime().addShutdownHook(new Thread(this::delete));
        }
    }

    public void write(String content) {
        Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
        Files.writeString(this.file, (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public String read() {
        return Files.readString(this.file, StandardCharsets.UTF_8);
    }

    public boolean exists() {
        return Files.exists(this.file, new LinkOption[0]);
    }

    public boolean delete() {
        try {
            return Files.deleteIfExists(this.file);
        }
        catch (IOException ignored) {
            return false;
        }
    }
}

