/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.events;

import dev.comfast.events.model.AfterEvent;
import dev.comfast.events.model.BeforeEvent;
import java.util.function.Supplier;

public interface EventsNotifier<T> {
    public void notifyBefore(BeforeEvent<T> var1);

    public void notifyAfter(AfterEvent<T> var1);

    default public void action(String name, Runnable actionFunc) {
        this.action(new BeforeEvent<Object>(null, name, new Object[0]), actionFunc);
    }

    default public <R> R action(String name, Supplier<R> actionFunc) {
        return this.action(new BeforeEvent<Object>(null, name, new Object[0]), actionFunc);
    }

    default public void action(BeforeEvent<T> event, Runnable actionFunc) {
        this.action(event, () -> {
            actionFunc.run();
            return "done";
        });
    }

    default public <R> R action(BeforeEvent<T> event, Supplier<R> actionFunc) {
        R result;
        this.notifyBefore(event);
        try {
            result = actionFunc.get();
        }
        catch (Exception e) {
            this.notifyAfter(event.failed(e));
            throw e;
        }
        this.notifyAfter(event.passed(result));
        return result;
    }
}

