/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.events;

import dev.comfast.events.EventListener;
import dev.comfast.events.EventsNotifier;
import dev.comfast.events.SubscriberManager;
import dev.comfast.events.model.AfterEvent;
import dev.comfast.events.model.BeforeEvent;
import dev.comfast.events.model.InvalidEventConfiguration;
import dev.comfast.util.Utils;
import java.util.HashMap;
import java.util.Map;

public class EventsManager<T>
implements SubscriberManager<T>,
EventsNotifier<T> {
    private final Map<String, EventListener<T>> eventListeners = new HashMap<String, EventListener<T>>();

    @Override
    public void subscribe(String key, EventListener<T> listener) {
        if (Utils.isNullOrEmpty(key)) {
            throw new InvalidEventConfiguration("Listener name should be not null/empty.");
        }
        if (this.eventListeners.get(key) != null) {
            throw new InvalidEventConfiguration(String.format("Listener with key: '%s' already added. Use another key, or call unsubscribe(\"%s\") before.", key, key));
        }
        this.eventListeners.put(key, listener);
    }

    @Override
    public void unsubscribe(String key) {
        this.eventListeners.remove(key);
    }

    @Override
    public void notifyBefore(BeforeEvent<T> e) {
        this.eventListeners.values().forEach(l -> l.before(e));
    }

    @Override
    public void notifyAfter(AfterEvent<T> e) {
        this.eventListeners.values().forEach(l -> l.after(e));
    }

    EventsManager() {
    }
}

