/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.util.waiter;

import dev.comfast.util.TerminalGenerator;
import dev.comfast.util.time.TimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WaiterStats {
    private final Map<Class<? extends Throwable>, Throwable> errors = new HashMap<Class<? extends Throwable>, Throwable>();
    private final List<WaiterErrorResult> errorResults = new ArrayList<WaiterErrorResult>();

    public void addError(Throwable error, long time, long loopTime) {
        this.errors.put(error.getClass(), error);
        this.errorResults.add(new WaiterErrorResult(time, loopTime, error.getClass()));
    }

    public Throwable recentError() {
        Class<? extends Throwable> type = this.errorResults.get((int)(this.errorResults.size() - 1)).clazz;
        return this.errors.get(type);
    }

    public String getStats() {
        TimeFormatter timeFormatter = new TimeFormatter();
        List[] data = new List[this.errorResults.size()];
        ArrayList<Class<? extends Throwable>> addedErrors = new ArrayList<Class<? extends Throwable>>();
        for (int i = this.errorResults.size() - 1; i >= 0; --i) {
            WaiterErrorResult result = this.errorResults.get(i);
            Object description = "";
            if (!addedErrors.contains(result.clazz)) {
                description = ": " + this.errors.get(result.clazz).getMessage();
                addedErrors.add(result.clazz);
            }
            data[i] = List.of(timeFormatter.formatNanoseconds(result.time * 1000000L), timeFormatter.formatNanoseconds(result.loopTime * 1000000L), result.clazz.getSimpleName() + (String)description);
        }
        return new TerminalGenerator(" | ").table(List.of("time", "loopTime", "error"), Arrays.asList(data));
    }

    private static class WaiterErrorResult {
        final long time;
        final long loopTime;
        final Class<? extends Throwable> clazz;

        public WaiterErrorResult(long time, long loopTime, Class<? extends Throwable> clazz) {
            this.time = time;
            this.loopTime = loopTime;
            this.clazz = clazz;
        }
    }
}

