/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.experimental.events;

import dev.comfast.experimental.events.AfterEvent;
import dev.comfast.experimental.events.BeforeEvent;
import dev.comfast.experimental.events.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class EventsManager<EventContext> {
    private final Map<String, EventListener<EventContext>> listeners = new HashMap<String, EventListener<EventContext>>();

    public void addListener(String listenerName, EventListener<EventContext> listener) {
        if (listenerName.isEmpty()) {
            throw new RuntimeException("Listener name should be not empty.");
        }
        if (listener == null) {
            throw new RuntimeException("Listener should not be null.");
        }
        this.listeners.put(listenerName, listener);
    }

    public void removeListener(String name) {
        this.listeners.remove(name);
    }

    public void action(BeforeEvent<EventContext> event, Runnable actionFunc) {
        this.action(event, () -> {
            actionFunc.run();
            return "done";
        });
    }

    public <T> T action(BeforeEvent<EventContext> beforeEvent, Supplier<T> actionFunc) {
        AfterEvent<EventContext> afterEvent = null;
        for (EventListener<EventContext> l : this.listeners.values()) {
            l.before(beforeEvent);
        }
        try {
            T result = actionFunc.get();
            afterEvent = beforeEvent.passed(result);
            T t = result;
            return t;
        }
        catch (Throwable e) {
            afterEvent = beforeEvent.failed(e);
            throw e;
        }
        finally {
            for (EventListener<EventContext> l : this.listeners.values()) {
                l.after(afterEvent);
            }
        }
    }

    EventsManager() {
    }
}

