/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.experimental.events;

import dev.comfast.experimental.events.AfterEvent;
import dev.comfast.util.time.Stopwatch;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BeforeEvent<EventContext> {
    public final EventContext context;
    public final String actionName;
    public final Object[] actionParams;
    private final Stopwatch stopwatch = new Stopwatch();

    public BeforeEvent(EventContext context, String actionName, Object ... actionParams) {
        this.context = context;
        this.actionName = actionName;
        this.actionParams = actionParams;
    }

    public AfterEvent<EventContext> passed(Object result) {
        return new AfterEvent<EventContext>(this.context, this.actionName, this.actionParams, this.stopwatch.time(), result, null);
    }

    public AfterEvent<EventContext> failed(Throwable error) {
        return new AfterEvent<EventContext>(this.context, this.actionName, this.actionParams, this.stopwatch.time(), null, error);
    }

    public String toString() {
        return String.format("%s(%s) IN PROGRESS... %s", this.actionName, Stream.of(this.actionParams).map(Object::toString).collect(Collectors.joining(", ")), this.stopwatch.time());
    }

    public EventContext getContext() {
        return this.context;
    }

    public String getActionName() {
        return this.actionName;
    }

    public Object[] getActionParams() {
        return this.actionParams;
    }

    public Stopwatch getStopwatch() {
        return this.stopwatch;
    }
}

