/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.util.waiter;

import dev.comfast.util.waiter.WaiterConfig;

public class WaiterState {
    private final WaiterConfig conf;
    private final long startedTimestamp;
    private int tries;
    private long loopStartTime;
    private long loopEndTime;

    public WaiterState(WaiterConfig config) {
        this.conf = config;
        this.tries = -1;
        this.startedTimestamp = System.currentTimeMillis();
    }

    public boolean nextTry() {
        long now = this.getTime();
        ++this.tries;
        this.loopStartTime = now;
        this.loopEndTime = this.loopStartTime + this.calculatePoolingTime(this.loopStartTime);
        return this.tries == 0 || now < this.conf.timeoutMs;
    }

    long getTime() {
        return System.currentTimeMillis() - this.startedTimestamp;
    }

    long getLoopTime() {
        return this.getTime() - this.loopStartTime;
    }

    long getTimeTillNextLoop() {
        return Math.max(0L, this.loopEndTime - this.getTime());
    }

    long calculatePoolingTime(long currentWaitTimeMs) {
        long calculatedTime = currentWaitTimeMs / this.conf.poolingDivider;
        if (calculatedTime < this.conf.poolingMinMs) {
            calculatedTime = this.conf.poolingMinMs;
        }
        if (calculatedTime > this.conf.poolingMaxMs) {
            calculatedTime = this.conf.poolingMaxMs;
        }
        if (currentWaitTimeMs + calculatedTime > this.conf.timeoutMs) {
            calculatedTime = this.conf.timeoutMs - currentWaitTimeMs;
        }
        return calculatedTime;
    }

    public int getTries() {
        return this.tries;
    }
}

