/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.util.waiter;

public final class WaiterConfig {
    public final long timeoutMs;
    public final long poolingMinMs;
    public final long poolingMaxMs;
    public final long poolingDivider;
    public final String description;
    public final boolean includeCauseInErrorMessage;

    public static WaiterConfigBuilder builder() {
        return new WaiterConfigBuilder();
    }

    public WaiterConfigBuilder toBuilder() {
        return new WaiterConfigBuilder().timeoutMs(this.timeoutMs).poolingMinMs(this.poolingMinMs).poolingMaxMs(this.poolingMaxMs).poolingDivider(this.poolingDivider).description(this.description).includeCauseInErrorMessage(this.includeCauseInErrorMessage);
    }

    public WaiterConfig(long timeoutMs, long poolingMinMs, long poolingMaxMs, long poolingDivider, String description, boolean includeCauseInErrorMessage) {
        this.timeoutMs = timeoutMs;
        this.poolingMinMs = poolingMinMs;
        this.poolingMaxMs = poolingMaxMs;
        this.poolingDivider = poolingDivider;
        this.description = description;
        this.includeCauseInErrorMessage = includeCauseInErrorMessage;
    }

    public static class WaiterConfigBuilder {
        private long timeoutMs;
        private long poolingMinMs;
        private long poolingMaxMs;
        private long poolingDivider;
        private String description;
        private boolean includeCauseInErrorMessage;

        WaiterConfigBuilder() {
        }

        public WaiterConfigBuilder timeoutMs(long timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }

        public WaiterConfigBuilder poolingMinMs(long poolingMinMs) {
            this.poolingMinMs = poolingMinMs;
            return this;
        }

        public WaiterConfigBuilder poolingMaxMs(long poolingMaxMs) {
            this.poolingMaxMs = poolingMaxMs;
            return this;
        }

        public WaiterConfigBuilder poolingDivider(long poolingDivider) {
            this.poolingDivider = poolingDivider;
            return this;
        }

        public WaiterConfigBuilder description(String description) {
            this.description = description;
            return this;
        }

        public WaiterConfigBuilder includeCauseInErrorMessage(boolean includeCauseInErrorMessage) {
            this.includeCauseInErrorMessage = includeCauseInErrorMessage;
            return this;
        }

        public WaiterConfig build() {
            return new WaiterConfig(this.timeoutMs, this.poolingMinMs, this.poolingMaxMs, this.poolingDivider, this.description, this.includeCauseInErrorMessage);
        }

        public String toString() {
            return "WaiterConfig.WaiterConfigBuilder(timeoutMs=" + this.timeoutMs + ", poolingMinMs=" + this.poolingMinMs + ", poolingMaxMs=" + this.poolingMaxMs + ", poolingDivider=" + this.poolingDivider + ", description=" + this.description + ", includeCauseInErrorMessage=" + this.includeCauseInErrorMessage + ")";
        }
    }
}

