/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.util.waiter;

import dev.comfast.util.Utils;
import dev.comfast.util.waiter.WaitTimeout;
import dev.comfast.util.waiter.WaiterConfig;
import dev.comfast.util.waiter.WaiterState;
import dev.comfast.util.waiter.WaiterStats;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class Waiter {
    private WaiterConfig conf;

    public Waiter(long timeoutMs) {
        this.conf = new WaiterConfig(timeoutMs, 50L, 5000L, 5L, "", true);
    }

    public Waiter configure(UnaryOperator<WaiterConfig.WaiterConfigBuilder> builderFunc) {
        this.conf = ((WaiterConfig.WaiterConfigBuilder)builderFunc.apply(this.conf.toBuilder())).build();
        return this;
    }

    public void waitFor(Runnable action) {
        this.doWaitFor(() -> {
            action.run();
            return true;
        }, false);
    }

    public <T> T waitFor(Supplier<T> action) {
        return this.doWaitFor(action, false);
    }

    public <T> T waitForValue(Supplier<T> action) {
        return this.doWaitFor(action, true);
    }

    private <T> T doWaitFor(Supplier<T> action, boolean shouldAssertResult) {
        WaiterState state = new WaiterState(this.conf);
        WaiterStats stats = new WaiterStats();
        while (state.nextTry()) {
            try {
                T result = action.get();
                if (shouldAssertResult && !Utils.isTruthly(result)) {
                    throw new IllegalArgumentException(String.format("Wait error. Action result is '%s'", Objects.toString(result, "null")));
                }
                return result;
            }
            catch (Throwable e) {
                stats.addError(e, state.getTime(), state.getLoopTime());
                Utils.sleep(state.getTimeTillNextLoop());
            }
        }
        throw new WaitTimeout(stats, String.format("Wait%s failed after %dms, tried %d times.%s", Utils.isNullOrEmpty(this.conf.description) ? "" : " for " + this.conf.description, this.conf.timeoutMs, state.getTries(), this.conf.includeCauseInErrorMessage && stats.recentError() != null ? " Last error:\n" + String.valueOf(stats.recentError()) : ""));
    }

    public Waiter() {
    }
}

