/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.experimental.events;

import dev.comfast.experimental.events.EventListener;
import dev.comfast.experimental.events.InvalidEventConfiguration;
import dev.comfast.experimental.events.model.AfterEvent;
import dev.comfast.experimental.events.model.BeforeEvent;
import dev.comfast.experimental.events.model.FailedEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class EventsManager<T> {
    private final Map<String, EventListener<T>> eventListeners = new HashMap<String, EventListener<T>>();

    public void addListener(String listenerKey, EventListener<T> listener) {
        if (listenerKey.isEmpty()) {
            throw new InvalidEventConfiguration("Listener name should be not empty.");
        }
        if (listener == null) {
            throw new InvalidEventConfiguration("Listener should not be null.");
        }
        this.eventListeners.put(listenerKey, listener);
    }

    public void removeListener(String name) {
        this.eventListeners.remove(name);
    }

    public void notifyBefore(BeforeEvent<T> e) {
        this.eventListeners.values().forEach(l -> l.before(e));
    }

    public void notifyAfter(AfterEvent<T> e) {
        this.eventListeners.values().forEach(l -> l.after(e));
    }

    public void notifyFailed(FailedEvent<T> e) {
        this.eventListeners.values().forEach(l -> l.failed(e));
    }

    public void action(BeforeEvent<T> event, Runnable actionFunc) {
        this.action(event, () -> {
            actionFunc.run();
            return "done";
        });
    }

    public <R> R action(BeforeEvent<T> event, Supplier<R> actionFunc) {
        R result;
        this.notifyBefore(event);
        try {
            result = actionFunc.get();
        }
        catch (Exception e) {
            this.notifyFailed(event.failed(e));
            throw e;
        }
        this.notifyAfter(event.passed(result));
        return result;
    }

    EventsManager() {
    }
}

