/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.util;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Utils {
    public static void sleep(long ms) {
        Thread.sleep(ms);
    }

    public static String trimString(Object input, int maxLength) {
        String str = input.toString();
        return str.length() > maxLength ? str.substring(0, maxLength) + "..." : str;
    }

    public static boolean isNullOrEmpty(Object anyString) {
        return anyString == null || anyString.toString().trim().isEmpty();
    }

    public static <T> List<List<T>> transposeMatrix(List<List<T>> matrix) {
        return IntStream.range(0, matrix.get(0).size()).mapToObj(i -> matrix.stream().map(row -> row.get(i)).collect(Collectors.toList())).collect(Collectors.toList());
    }

    public static void withSystemProp(String systemPropertyName, Runnable func) {
        String restoreValue = System.getProperty(systemPropertyName);
        try {
            func.run();
        }
        finally {
            if (restoreValue == null) {
                System.clearProperty(systemPropertyName);
            } else {
                System.setProperty(systemPropertyName, restoreValue);
            }
        }
    }

    public static boolean isTruthly(Object input) {
        if (input == null) {
            return false;
        }
        switch (input.toString().trim()) {
            case "": 
            case "false": 
            case "0": 
            case "0.0": {
                return false;
            }
        }
        return true;
    }
}

