/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.rgx;

import dev.comfast.rgx.RgxMatch;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;

public class Rgx {
    @Language(value="regexp")
    public final String pattern;
    private int flags = 0;

    public Rgx flags(int flags) {
        this.flags = flags;
        return this;
    }

    public RgxMatch match(String inputText) {
        Matcher m = Pattern.compile(this.pattern, this.flags).matcher(inputText);
        String[] found = m.find() ? this.readGroups(m) : null;
        return new RgxMatch(found, this.pattern, inputText);
    }

    public List<String> matchAllAsString(String inputText) {
        return this.matchAllAsString(inputText, 0);
    }

    public List<String> matchAllAsString(String inputText, int nthGroup) {
        return this.matchAll(inputText).stream().map(rgxMatch -> rgxMatch.get(nthGroup)).collect(Collectors.toList());
    }

    public List<RgxMatch> matchAll(String inputText) {
        Matcher m = Pattern.compile(this.pattern, this.flags).matcher(inputText);
        ArrayList<RgxMatch> list = new ArrayList<RgxMatch>();
        while (m.find()) {
            list.add(new RgxMatch(this.readGroups(m), this.pattern, inputText));
        }
        return list;
    }

    public String toString() {
        return this.pattern;
    }

    private String[] readGroups(Matcher matcher) {
        String[] groups = new String[matcher.groupCount() + 1];
        for (int i = 0; i < groups.length; ++i) {
            groups[i] = matcher.group(i);
        }
        return groups;
    }

    public Rgx(String pattern) {
        this.pattern = pattern;
    }
}

