/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.experimental.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import dev.comfast.experimental.config.ConfigFileType;
import dev.comfast.experimental.config.MapFlatter;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

class ConfigFile {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private static final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final MapFlatter flatter = new MapFlatter();
    private final String fileName;

    public Map<String, String> readAsFlatMap(boolean required) {
        try {
            ConfigFileType fileType = ConfigFileType.parse(this.fileName);
            String fileContent = this.readFileContent(this.fileName);
            Map<?, ?> fullMap = this.objectMapperRead(fileType, fileContent);
            return flatter.flat(fullMap);
        }
        catch (IOException e) {
            if (required) {
                throw e;
            }
            return new HashMap<String, String>();
        }
    }

    private String readFileContent(String fileName) throws IOException {
        Path rootPath = Path.of(fileName, new String[0]);
        if (rootPath.toFile().isFile() && rootPath.toFile().exists()) {
            return Files.readString(rootPath, StandardCharsets.UTF_8);
        }
        String fileFromResources = this.readResourceStream(fileName);
        if (fileFromResources != null) {
            return fileFromResources;
        }
        throw new IOException(String.format("Not found config file '%s', searched in locations: \n%s\n%s", fileName, rootPath.toFile().getAbsolutePath(), this.printResourcesFolders(fileName)));
    }

    private Map<?, ?> objectMapperRead(ConfigFileType type, String fileContent) {
        switch (type) {
            case JSON: {
                return (Map)jsonMapper.readValue(fileContent, Map.class);
            }
            case YAML: {
                return (Map)yamlMapper.readValue(fileContent, Map.class);
            }
            case PROPERTIES: {
                Properties p = new Properties();
                p.load(new StringReader(fileContent));
                return p;
            }
        }
        throw new RuntimeException("never happen");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private String readResourceStream(String fileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String printResourcesFolders(String suffix) {
        try {
            StringBuilder result = new StringBuilder();
            this.getClass().getClassLoader().getResources("").asIterator().forEachRemaining(url -> {
                String path = url.toString();
                if (path.startsWith("file") && path.contains("resources")) {
                    result.append(path.replaceFirst("^file:.", "")).append(suffix).append("\n");
                }
            });
            return result.toString();
        }
        catch (IOException e) {
            return "java resources folders";
        }
    }

    public ConfigFile(String fileName) {
        this.fileName = fileName;
    }
}

