/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.util;

import dev.comfast.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class TerminalGenerator {
    private final String separator;
    private final String linePrefix;
    private final String lineSuffix;

    public TerminalGenerator() {
        this(" ", "", "");
    }

    public TerminalGenerator(String separator) {
        this(separator, "", "");
    }

    public String table(List<String> columnHeaders, List<List<String>> dataRows) {
        if (dataRows.size() == 0) {
            throw new IllegalArgumentException("Empty data passed");
        }
        if (dataRows.get(0).size() != columnHeaders.size()) {
            throw new IllegalArgumentException("Data rows count should match headers count");
        }
        ArrayList allRows = new ArrayList(dataRows);
        allRows.add(0, columnHeaders);
        return this.printColumns(Utils.transposeMatrix(allRows));
    }

    public String horizontalTable(List<String> rowHeaders, List<List<String>> dataRows) {
        if (rowHeaders.size() != dataRows.size()) {
            throw new IllegalArgumentException("Headers count should match data count.");
        }
        if (dataRows.size() == 0) {
            throw new IllegalArgumentException("Empty data passed");
        }
        ArrayList<List<String>> allColumns = new ArrayList<List<String>>(Utils.transposeMatrix(dataRows));
        allColumns.add(0, rowHeaders.stream().map(h -> h + ":").collect(Collectors.toList()));
        return this.printColumns(allColumns);
    }

    private String printColumns(List<List<String>> columns) {
        List alignedColumns = columns.stream().map(this::alignSpaces).collect(Collectors.toList());
        return Utils.transposeMatrix(alignedColumns).stream().map(this::joinLine).collect(Collectors.joining("\n"));
    }

    @NotNull
    private String joinLine(List<String> line) {
        return (this.linePrefix + String.join((CharSequence)this.separator, line) + this.lineSuffix).trim();
    }

    private List<String> alignSpaces(List<String> strings) {
        int MAX_LENGTH = strings.stream().mapToInt(String::length).max().orElseThrow();
        return strings.stream().map(s -> this.fixedLength((String)s, MAX_LENGTH)).collect(Collectors.toList());
    }

    @NotNull
    private String fixedLength(String input, int LENGTH) {
        return String.format("%-" + LENGTH + "s", input).substring(0, LENGTH);
    }

    public TerminalGenerator(String separator, String linePrefix, String lineSuffix) {
        this.separator = separator;
        this.linePrefix = linePrefix;
        this.lineSuffix = lineSuffix;
    }
}

