/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.experimental.events.model;

import dev.comfast.experimental.events.model.AfterEvent;
import dev.comfast.experimental.events.model.FailedEvent;
import dev.comfast.util.time.Stopwatch;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Event<EventContext> {
    public final EventContext context;
    public final String actionName;
    public final Object[] actionParams;
    protected final Stopwatch stopwatch = new Stopwatch();

    public Event(EventContext context, String actionName, Object ... actionParams) {
        this.context = context;
        this.actionName = actionName;
        this.actionParams = actionParams;
    }

    public AfterEvent<EventContext> passed(Object result) {
        return new AfterEvent(this, result);
    }

    public FailedEvent<EventContext> failed(Throwable error) {
        return new FailedEvent(this, error);
    }

    public String toString() {
        return String.format("%s %s(%s)", this.getClass().getSimpleName(), this.actionName, Stream.of(this.actionParams).map(Object::toString).collect(Collectors.joining(", ")));
    }

    public EventContext getContext() {
        return this.context;
    }

    public String getActionName() {
        return this.actionName;
    }

    public Object[] getActionParams() {
        return this.actionParams;
    }

    public Stopwatch getStopwatch() {
        return this.stopwatch;
    }
}

