/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.experimental.events;

import dev.comfast.experimental.events.EventListener;
import dev.comfast.experimental.events.model.AfterEvent;
import dev.comfast.experimental.events.model.Event;
import dev.comfast.experimental.events.model.FailedEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class EventsManager<EventContext> {
    private final Map<String, EventListener<EventContext>> listeners = new HashMap<String, EventListener<EventContext>>();

    public void addListener(String listenerName, EventListener<EventContext> listener) {
        if (listenerName.isEmpty()) {
            throw new RuntimeException("Listener name should be not empty.");
        }
        if (listener == null) {
            throw new RuntimeException("Listener should not be null.");
        }
        this.listeners.put(listenerName, listener);
    }

    public void removeListener(String name) {
        this.listeners.remove(name);
    }

    public void callEvent(Event<EventContext> event) {
        for (EventListener<EventContext> listener : this.listeners.values()) {
            listener.before(event);
        }
    }

    public void callEvent(AfterEvent<EventContext> event) {
        for (EventListener<EventContext> listener : this.listeners.values()) {
            listener.after(event);
        }
    }

    public void callEvent(FailedEvent<EventContext> event) {
        for (EventListener<EventContext> listener : this.listeners.values()) {
            listener.failed(event);
        }
    }

    public void action(Event<EventContext> event, Runnable actionFunc) {
        this.action(event, () -> {
            actionFunc.run();
            return "done";
        });
    }

    public <T> T action(Event<EventContext> event, Supplier<T> actionFunc) {
        this.callEvent(event);
        try {
            T result = actionFunc.get();
            this.callEvent(event.passed(result));
            return result;
        }
        catch (Throwable e) {
            this.callEvent(event.failed(e));
            throw e;
        }
    }

    EventsManager() {
    }
}

