/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.experimental.config;

import dev.comfast.experimental.config.ConfigFile;
import dev.comfast.util.ErrorKit;
import java.util.Map;

public class ConfigReader {
    private final Map<String, String> appConfig;
    private final Map<String, String> referenceConfig = new ConfigFile("referenceConfig.yaml").readAsFlatMap(false);

    public ConfigReader() {
        this.appConfig = new ConfigFile("appConfig.yaml").readAsFlatMap(false);
    }

    public double getDouble(String key) {
        return ErrorKit.rethrow(() -> Double.parseDouble(this.getString(key)), "Invalid format for config key: " + key, new Object[0]);
    }

    public long getLong(String key) {
        return ErrorKit.rethrow(() -> Long.parseLong(this.getString(key)), "Invalid format for config key: " + key, new Object[0]);
    }

    public boolean getBool(String key) {
        String str = this.getString(key);
        return ErrorKit.rethrow(() -> Boolean.parseBoolean(str), "Invalid format for config key: " + key, new Object[0]);
    }

    public String getString(String key) {
        String sysProp = System.getProperty(key);
        if (sysProp != null) {
            return sysProp;
        }
        String appProp = this.appConfig.get(key);
        if (appProp != null) {
            return appProp;
        }
        String defaultProp = this.referenceConfig.get(key);
        if (defaultProp != null) {
            return defaultProp;
        }
        throw new RuntimeException(String.format("Not found key: '%s' in config. Available keys are: \n%s", key, String.join((CharSequence)"\n", this.referenceConfig.keySet())));
    }
}

