/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.experimental.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import dev.comfast.experimental.config.ConfigFileType;
import dev.comfast.experimental.config.MapFlatter;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

class ConfigFile {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private static final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final MapFlatter flatter = new MapFlatter();
    private final String fileName;

    public Map<String, String> readAsFlatMap(boolean required) {
        try {
            ConfigFileType fileType = ConfigFileType.parse(this.fileName);
            String fileContent = this.readFileContent(this.fileName);
            Map<?, ?> fullMap = this.objectMapperRead(fileType, fileContent);
            return flatter.flat(fullMap);
        }
        catch (IOException e) {
            if (required) {
                throw e;
            }
            return new HashMap<String, String>();
        }
    }

    private String readFileContent(String fileName) throws IOException, URISyntaxException {
        Path rootPath = Path.of(fileName, new String[0]);
        URL resourcesUrl = this.getClass().getClassLoader().getResource(fileName);
        if (rootPath.toFile().isFile() && rootPath.toFile().exists()) {
            return Files.readString(rootPath, StandardCharsets.UTF_8);
        }
        if (resourcesUrl != null) {
            Path path = Paths.get(resourcesUrl.toURI());
            return Files.readString(path, StandardCharsets.UTF_8);
        }
        throw new IOException(String.format("Not found config file '%s', searched in locations: \n%s\n%s", fileName, rootPath.toFile().getAbsolutePath(), this.printResourcesFolders(fileName)));
    }

    private Map<?, ?> objectMapperRead(ConfigFileType type, String fileContent) {
        switch (type) {
            case JSON: {
                return (Map)jsonMapper.readValue(fileContent, Map.class);
            }
            case YAML: {
                return (Map)yamlMapper.readValue(fileContent, Map.class);
            }
            case PROPERTIES: {
                Properties p = new Properties();
                p.load(new StringReader(fileContent));
                return p;
            }
        }
        throw new RuntimeException("never happen");
    }

    private String printResourcesFolders(String suffix) {
        try {
            StringBuilder result = new StringBuilder();
            this.getClass().getClassLoader().getResources("").asIterator().forEachRemaining(url -> {
                String path = url.toString();
                if (path.startsWith("file") && path.contains("resources")) {
                    result.append(path.replaceFirst("^file:.", "")).append(suffix).append("\n");
                }
            });
            return result.toString();
        }
        catch (IOException e) {
            return "java resources folders";
        }
    }

    public ConfigFile(String fileName) {
        this.fileName = fileName;
    }
}

