/*
 * Decompiled with CFR 0.152.
 */
package dev.comfast.rgx;

import dev.comfast.rgx.RgxNotFound;

public class RgxMatch {
    public static final int ERR_MSG_MAX_LENGTH = 2000;
    private final String[] foundGroups;
    private final String pattern;
    private final String input;

    public String get() {
        return this.group(0);
    }

    public String group(int nth) {
        this.throwIfEmpty();
        if (this.foundGroups.length <= nth) {
            throw new RgxNotFound("Match doesn't contain group #%d in %d total groups\nMatch found by pattern '%s' in input:\n%s", nth, this.foundGroups.length - 1, this.pattern, this.shortInput());
        }
        return this.foundGroups[nth];
    }

    public boolean isPresent() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.foundGroups == null;
    }

    public String orElse(String elseValue) {
        return this.isPresent() ? this.get() : elseValue;
    }

    public RgxMatch throwIfEmpty() {
        return this.throwIfEmpty("", new Object[0]);
    }

    public RgxMatch throwIfEmpty(String failMsg, Object ... msgArgs) {
        if (this.isPresent()) {
            return this;
        }
        RgxNotFound cause = new RgxNotFound("Not found pattern '%s' in text:\n%s", this.pattern, this.shortInput());
        throw failMsg == null || failMsg.isEmpty() ? cause : new RgxNotFound(failMsg, (Throwable)cause, msgArgs);
    }

    private String shortInput() {
        return this.input.length() < 2000 ? this.input : this.input.substring(0, 2000);
    }

    public RgxMatch(String[] foundGroups, String pattern, String input) {
        this.foundGroups = foundGroups;
        this.pattern = pattern;
        this.input = input;
    }
}

