/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.finance;

import dev.codesoapbox.dummy4j.Dummy4j;
import dev.codesoapbox.dummy4j.dummies.finance.CreditCardBuilder;
import dev.codesoapbox.dummy4j.dummies.finance.CreditCardNumberBuilder;
import dev.codesoapbox.dummy4j.dummies.finance.IbanBuilder;
import dev.codesoapbox.dummy4j.dummies.finance.IbanFormula;
import dev.codesoapbox.dummy4j.dummies.finance.LuhnFormula;

public class FinanceBuilderFactory {
    private final Dummy4j dummy4j;
    private final IbanFormula ibanFormula;
    private final LuhnFormula luhnFormula;

    FinanceBuilderFactory(Dummy4j dummy4j, IbanFormula ibanFormula, LuhnFormula luhnFormula) {
        this.dummy4j = dummy4j;
        this.ibanFormula = ibanFormula;
        this.luhnFormula = luhnFormula;
    }

    public static FinanceBuilderFactory newInstance(Dummy4j dummy4j) {
        return new FinanceBuilderFactory(dummy4j, new IbanFormula(), new LuhnFormula());
    }

    IbanBuilder createIbanBuilder() {
        return new IbanBuilder(this.dummy4j, this.ibanFormula);
    }

    CreditCardNumberBuilder createCreditCardNumberBuilder() {
        return new CreditCardNumberBuilder(this.dummy4j, this.luhnFormula);
    }

    CreditCardBuilder createCreditCardBuilder() {
        return new CreditCardBuilder(this.dummy4j, this.createCreditCardNumberBuilder());
    }
}

