/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.finance;

import dev.codesoapbox.dummy4j.Dummy4j;
import dev.codesoapbox.dummy4j.dummies.finance.CreditCardProvider;
import dev.codesoapbox.dummy4j.dummies.finance.IINRange;
import dev.codesoapbox.dummy4j.dummies.finance.LuhnFormula;
import dev.codesoapbox.dummy4j.dummies.finance.Replace;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;

public class CreditCardNumberBuilder {
    static final String PARTIAL_CREDIT_CARD_KEY = "#{finance.credit_card_without_check_digit.";
    static final Pattern SANITIZE_NUMBER_PATTERN = Pattern.compile("[^\\d]");
    static final Pattern SANITIZE_DEFINITION_KEY_PATTERN = Pattern.compile("\\s", 256);
    private final Dummy4j dummy4j;
    private final LuhnFormula luhnFormula;
    private boolean withoutFormatting;
    private List<CreditCardProvider> providers = Collections.emptyList();

    public CreditCardNumberBuilder(Dummy4j dummy4j, LuhnFormula luhnFormula) {
        this.dummy4j = dummy4j;
        this.luhnFormula = luhnFormula;
    }

    public CreditCardNumberBuilder withProvider(CreditCardProvider provider) {
        this.providers = Collections.singletonList(provider);
        return this;
    }

    public CreditCardNumberBuilder withRandomProvider() {
        this.providers = Collections.emptyList();
        return this;
    }

    public CreditCardNumberBuilder withRandomProvider(CreditCardProvider ... providers) {
        this.providers = Arrays.asList(providers);
        return this;
    }

    public CreditCardNumberBuilder withoutFormatting() {
        this.withoutFormatting = true;
        return this;
    }

    public String build() {
        String uncheckedNumber = this.getNumberWithIIN();
        String number = uncheckedNumber + this.luhnFormula.generateCheckDigit(uncheckedNumber);
        if (!this.withoutFormatting) {
            return number;
        }
        return SANITIZE_NUMBER_PATTERN.matcher(number).replaceAll("");
    }

    private String getNumberWithIIN() {
        CreditCardProvider provider = Optional.ofNullable(this.dummy4j.of(this.providers)).orElseGet(() -> this.dummy4j.nextEnum(CreditCardProvider.class));
        String resolvedDefinition = this.dummy4j.expressionResolver().resolve(this.getProviderKey(provider));
        return Replace.replaceCharactersConditionally(resolvedDefinition, this.getIIN(provider), Character::isDigit);
    }

    private String getProviderKey(CreditCardProvider provider) {
        String providerNameInLowerCase = provider.getName().toLowerCase(Locale.ENGLISH);
        String providerKey = SANITIZE_DEFINITION_KEY_PATTERN.matcher(providerNameInLowerCase).replaceAll("_");
        return PARTIAL_CREDIT_CARD_KEY + providerKey + "}";
    }

    private String getIIN(CreditCardProvider provider) {
        IINRange range = this.dummy4j.of(provider.getIinRanges());
        return String.valueOf(this.dummy4j.number().nextInt(range.getMin(), range.getMax()));
    }

    public String toString() {
        return "CreditCardNumberBuilder{providers=" + this.providers + ", withoutFormatting=" + this.withoutFormatting + '}';
    }
}

