/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.color;

import dev.codesoapbox.dummy4j.dummies.shared.math.NumberFormatter;
import dev.codesoapbox.dummy4j.dummies.shared.math.NumberValidator;
import dev.codesoapbox.dummy4j.dummies.shared.math.Round;
import java.util.Objects;

public class HSL {
    final float hue;
    final float saturation;
    final float lightness;

    public HSL(float hue, float saturation, float lightness) {
        this.validate(hue, saturation, lightness);
        this.hue = Round.toTwoDecimals(hue);
        this.saturation = Round.toTwoDecimals(saturation);
        this.lightness = Round.toTwoDecimals(lightness);
    }

    private void validate(float hue, float saturation, float lightness) {
        NumberValidator.inRange(hue, -360.0f, 360.0f);
        NumberValidator.betweenZeroAndOne(saturation);
        NumberValidator.betweenZeroAndOne(lightness);
    }

    public float getHue() {
        return this.hue;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public float getLightness() {
        return this.lightness;
    }

    public float[] toArray() {
        return new float[]{this.hue, this.saturation, this.lightness};
    }

    public String toString() {
        return "hsl(" + NumberFormatter.toTwoDecimals(this.hue) + ", " + NumberFormatter.toPercent(this.saturation) + ", " + NumberFormatter.toPercent(this.lightness) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HSL hsl = (HSL)o;
        return Float.compare(hsl.hue, this.hue) == 0 && Float.compare(hsl.saturation, this.saturation) == 0 && Float.compare(hsl.lightness, this.lightness) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.hue), Float.valueOf(this.saturation), Float.valueOf(this.lightness));
    }
}

