/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.definitions.providers.files.yaml;

import dev.codesoapbox.dummy4j.definitions.providers.files.ResourceStreamProvider;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.yaml.snakeyaml.Yaml;

class YamlFileLoader {
    private static final Logger LOG = Logger.getLogger(YamlFileLoader.class.getName());
    private static final Pattern FILE_PATTERN = Pattern.compile(".*\\.yml");
    private static final List<Pattern> RESOURCES_PREFIX_PATTERNS = Collections.singletonList(Pattern.compile("^BOOT-INF/classes/"));
    private final Yaml yaml;
    private final Reflections reflections;
    private final ResourceStreamProvider resourceStreamProvider;

    YamlFileLoader(Yaml yaml, Reflections reflections, ResourceStreamProvider resourceStreamProvider) {
        this.yaml = yaml;
        this.reflections = reflections;
        this.resourceStreamProvider = resourceStreamProvider;
    }

    static YamlFileLoader standard() {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new ResourcesScanner()}).setUrls(ClasspathHelper.forJavaClassPath()).addUrls(ClasspathHelper.forClassLoader()));
        return new YamlFileLoader(new Yaml(), reflections, new ResourceStreamProvider());
    }

    List<Map<String, Object>> loadYamlFiles(List<String> paths) {
        Set resources = this.reflections.getResources(FILE_PATTERN);
        LOG.log(Level.FINE, "Loading definitions from files: {0}", resources);
        return resources.stream().map(this::removeResourcePrefixes).distinct().filter(r -> this.isInAllowedPath((String)r, paths)).map(this::loadResourceAsMap).collect(Collectors.toList());
    }

    private String removeResourcePrefixes(String resourcePath) {
        for (Pattern pattern : RESOURCES_PREFIX_PATTERNS) {
            resourcePath = pattern.matcher(resourcePath).replaceFirst(resourcePath);
        }
        return resourcePath;
    }

    private Map<String, Object> loadResourceAsMap(String r) {
        InputStream inputStream = this.resourceStreamProvider.get(r);
        return (Map)this.yaml.load(inputStream);
    }

    private boolean isInAllowedPath(String resourcePath, List<String> paths) {
        for (String path : paths) {
            if (!resourcePath.startsWith(path)) continue;
            return true;
        }
        return false;
    }
}

