/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j;

import dev.codesoapbox.dummy4j.RandomService;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public final class DefaultRandomService
implements RandomService {
    private static final String UPPER_BOUND_MUST_BE_POSITIVE = "Upper bound must be positive or zero";
    private static final String LOWER_BOUND_MUST_BE_POSITIVE = "Lower bound must be positive or zero";
    private static final String LOWER_BOUND_MUST_NOT_BE_GREATER_THAN_UPPER = "Lower bound must not be greater than upper bound";
    private final long seed;
    private final Random random;

    DefaultRandomService(Random random, long seed) {
        this.random = random;
        this.seed = seed;
    }

    public DefaultRandomService() {
        this(null);
    }

    public DefaultRandomService(Long seed) {
        this.seed = seed != null ? seed : (long)ThreadLocalRandom.current().nextInt();
        this.random = new Random(this.seed);
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public long nextLong() {
        return this.random.nextLong() & Long.MAX_VALUE;
    }

    @Override
    public boolean nextBoolean() {
        return this.random.nextBoolean();
    }

    @Override
    public int nextInt() {
        return this.random.nextInt() & Integer.MAX_VALUE;
    }

    @Override
    public int nextInt(int upperBound) {
        return this.nextInt(0, upperBound);
    }

    @Override
    public int nextInt(int lowerBound, int upperBound) {
        if (lowerBound < 0) {
            throw new IllegalArgumentException(LOWER_BOUND_MUST_BE_POSITIVE);
        }
        if (upperBound < 0) {
            throw new IllegalArgumentException(UPPER_BOUND_MUST_BE_POSITIVE);
        }
        if (upperBound < lowerBound) {
            throw new IllegalArgumentException(LOWER_BOUND_MUST_NOT_BE_GREATER_THAN_UPPER);
        }
        if (upperBound == Integer.MAX_VALUE && lowerBound != Integer.MAX_VALUE) {
            --upperBound;
        }
        return lowerBound + this.random.nextInt(upperBound - lowerBound + 1);
    }

    @Override
    public long nextLong(long upperBound) {
        return this.nextLong(0L, upperBound);
    }

    @Override
    public long nextLong(long lowerBound, long upperBound) {
        if (lowerBound < 0L) {
            throw new IllegalArgumentException(LOWER_BOUND_MUST_BE_POSITIVE);
        }
        if (upperBound < 0L) {
            throw new IllegalArgumentException(UPPER_BOUND_MUST_BE_POSITIVE);
        }
        if (upperBound < lowerBound) {
            throw new IllegalArgumentException(LOWER_BOUND_MUST_NOT_BE_GREATER_THAN_UPPER);
        }
        if (upperBound == Long.MAX_VALUE && lowerBound != Long.MAX_VALUE) {
            --upperBound;
        }
        return lowerBound + (long)(this.random.nextDouble() * (double)(upperBound - lowerBound + 1L));
    }

    @Override
    public double nextDouble() {
        return this.random.nextDouble();
    }

    @Override
    public double nextDouble(double upperBound) {
        return this.nextDouble(0.0, upperBound);
    }

    @Override
    public double nextDouble(double lowerBound, double upperBound) {
        if (lowerBound < 0.0) {
            throw new IllegalArgumentException(LOWER_BOUND_MUST_BE_POSITIVE);
        }
        if (upperBound < 0.0) {
            throw new IllegalArgumentException(UPPER_BOUND_MUST_BE_POSITIVE);
        }
        if (upperBound < lowerBound) {
            throw new IllegalArgumentException(LOWER_BOUND_MUST_NOT_BE_GREATER_THAN_UPPER);
        }
        return lowerBound + (upperBound - lowerBound) * this.random.nextDouble();
    }

    @Override
    public float nextFloat() {
        return this.nextFloat(1.0f);
    }

    @Override
    public float nextFloat(float upperBound) {
        return this.nextFloat(0.0f, upperBound);
    }

    @Override
    public float nextFloat(float lowerBound, float upperBound) {
        if (lowerBound < 0.0f) {
            throw new IllegalArgumentException(LOWER_BOUND_MUST_BE_POSITIVE);
        }
        if (upperBound < 0.0f) {
            throw new IllegalArgumentException(UPPER_BOUND_MUST_BE_POSITIVE);
        }
        if (upperBound < lowerBound) {
            throw new IllegalArgumentException(LOWER_BOUND_MUST_NOT_BE_GREATER_THAN_UPPER);
        }
        return this.random.nextFloat() * (upperBound - lowerBound) + lowerBound;
    }
}

