/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j;

import com.google.common.collect.Maps;
import dev.codesoapbox.dummy4j.ExpressionResolver;
import dev.codesoapbox.dummy4j.RandomService;
import dev.codesoapbox.dummy4j.definitions.LocalizedDummyDefinitions;
import dev.codesoapbox.dummy4j.definitions.providers.DefinitionProvider;
import dev.codesoapbox.dummy4j.exceptions.MissingLocaleDefinitionsException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DefaultExpressionResolver
implements ExpressionResolver {
    private static final String ESCAPE_PREFIX = "\\\\?";
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("#\\{(.*?)}");
    private static final Pattern DIGIT_PATTERN = Pattern.compile("\\\\?#(?!\\{)");
    final RandomService randomService;
    final List<String> locales;
    final Map<String, LocalizedDummyDefinitions> localizedDefinitions;

    public DefaultExpressionResolver(List<String> locales, RandomService randomService, DefinitionProvider definitionProvider) {
        if (locales == null || locales.isEmpty()) {
            locales = Collections.singletonList("en");
        }
        this.locales = locales;
        this.randomService = randomService;
        this.localizedDefinitions = Maps.uniqueIndex(definitionProvider.get(), LocalizedDummyDefinitions::getLocale);
        locales.forEach(locale -> {
            if (!this.localizedDefinitions.containsKey(locale)) {
                throw new MissingLocaleDefinitionsException((String)locale);
            }
        });
    }

    @Override
    public String resolve(String expression) {
        String result = this.resolveAllKeysAndDigits(expression);
        if (!VARIABLE_PATTERN.matcher(result).find()) {
            return result;
        }
        return this.resolve(result);
    }

    private String resolveAllKeysAndDigits(String expression) {
        String expressionWithResolvedKeys = this.replaceKeyPlaceholders(expression);
        return this.replaceDigitPlaceholders(expressionWithResolvedKeys);
    }

    private String replaceKeyPlaceholders(String expression) {
        Matcher expressionMatcher = VARIABLE_PATTERN.matcher(expression);
        return this.replace(expression, expressionMatcher, () -> this.resolveKey(expressionMatcher.group(1)));
    }

    private String replaceDigitPlaceholders(String expressionWithResolvedKeys) {
        Matcher digitMatcher = DIGIT_PATTERN.matcher(expressionWithResolvedKeys);
        return this.replace(expressionWithResolvedKeys, digitMatcher, () -> String.valueOf(this.randomService.nextInt(9)));
    }

    private String replace(String expression, Matcher expressionMatcher, Supplier<String> replacementSupplier) {
        StringBuffer b = new StringBuffer(expression.length());
        while (expressionMatcher.find()) {
            if (expressionMatcher.group().charAt(0) == '\\') {
                expressionMatcher.appendReplacement(b, expressionMatcher.group().substring(1));
                continue;
            }
            expressionMatcher.appendReplacement(b, Matcher.quoteReplacement(replacementSupplier.get()));
        }
        expressionMatcher.appendTail(b);
        return b.toString();
    }

    private String resolveKey(String key) {
        for (String locale : this.locales) {
            List<String> result = this.localizedDefinitions.get(locale).resolve(key);
            if (result == null || result.isEmpty()) continue;
            return this.getRandom(result);
        }
        return "";
    }

    private String getRandom(List<String> result) {
        int i = this.randomService.nextInt(result.size() - 1);
        return result.get(i);
    }
}

