/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.color;

import dev.codesoapbox.dummy4j.dummies.color.HSL;
import dev.codesoapbox.dummy4j.dummies.shared.math.NumberFormatter;
import dev.codesoapbox.dummy4j.dummies.shared.math.NumberValidator;
import dev.codesoapbox.dummy4j.dummies.shared.math.Round;
import java.util.Objects;

public class HSLA
extends HSL {
    private final float alpha;

    public HSLA(float hue, float saturation, float lightness, float alpha) {
        super(hue, saturation, lightness);
        NumberValidator.betweenZeroAndOne(alpha);
        this.alpha = Round.toTwoDecimals(alpha);
    }

    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public float[] toArray() {
        return new float[]{this.hue, this.saturation, this.lightness, this.alpha};
    }

    @Override
    public String toString() {
        return "hsla(" + NumberFormatter.toTwoDecimals(this.hue) + ", " + NumberFormatter.toPercent(this.saturation) + ", " + NumberFormatter.toPercent(this.lightness) + ", " + NumberFormatter.toTwoDecimals(this.alpha) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HSLA hsla = (HSLA)o;
        return Float.compare(hsla.alpha, this.alpha) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Float.valueOf(this.alpha));
    }
}

