/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.color;

import dev.codesoapbox.dummy4j.dummies.shared.math.NumberFormatter;
import dev.codesoapbox.dummy4j.dummies.shared.math.NumberValidator;
import dev.codesoapbox.dummy4j.dummies.shared.math.Round;
import java.util.Objects;

public class HSB {
    protected final float hue;
    protected final float saturation;
    protected final float brightness;

    public HSB(float hue, float saturation, float brightness) {
        this.validate(hue, saturation, brightness);
        this.hue = Round.toTwoDecimals(hue);
        this.saturation = Round.toTwoDecimals(saturation);
        this.brightness = Round.toTwoDecimals(brightness);
    }

    private void validate(float hue, float saturation, float brightness) {
        NumberValidator.inRange(hue, -360.0f, 360.0f);
        NumberValidator.betweenZeroAndOne(saturation);
        NumberValidator.betweenZeroAndOne(brightness);
    }

    public float getHue() {
        return this.hue;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public float[] toArray() {
        return new float[]{this.hue, this.saturation, this.brightness};
    }

    public String toString() {
        return "hsb(" + NumberFormatter.toTwoDecimals(this.hue) + ", " + NumberFormatter.toPercent(this.saturation) + ", " + NumberFormatter.toPercent(this.brightness) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HSB hsb = (HSB)o;
        return Float.compare(hsb.hue, this.hue) == 0 && Float.compare(hsb.saturation, this.saturation) == 0 && Float.compare(hsb.brightness, this.brightness) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.hue), Float.valueOf(this.saturation), Float.valueOf(this.brightness));
    }
}

