/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.definitions;

import dev.codesoapbox.dummy4j.annotations.Experimental;
import dev.codesoapbox.dummy4j.exceptions.UniqueValueRetryLimitExceededException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Experimental
public class UniqueValues {
    private final Map<String, Set<Object>> usedValues = new ConcurrentHashMap<String, Set<Object>>();
    private int maxRetries = 10000;

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public <T> T value(String uniquenessGroup, Supplier<T> supplier) {
        Set usedValuesForMethod = this.usedValues.computeIfAbsent(uniquenessGroup, k -> ConcurrentHashMap.newKeySet());
        return this.provideUnique(uniquenessGroup, supplier, usedValuesForMethod);
    }

    private synchronized <T> T provideUnique(String uniquenessGroup, Supplier<T> supplier, Set<Object> usedValuesForMethod) {
        for (int i = 0; i <= this.maxRetries; ++i) {
            T result = supplier.get();
            if (usedValuesForMethod.contains(result)) continue;
            usedValuesForMethod.add(result);
            return result;
        }
        throw new UniqueValueRetryLimitExceededException(this.maxRetries, uniquenessGroup);
    }

    public <T> void within(Supplier<T> supplier, Consumer<Supplier<T>> within) {
        HashSet usedValuesForMethod = new HashSet();
        within.accept(() -> this.provideUnique(null, supplier, usedValuesForMethod));
    }

    public <T, E> E of(Supplier<T> supplier, Function<Supplier<T>, E> collector) {
        HashSet usedValuesForMethod = new HashSet();
        return collector.apply(() -> this.provideUnique(null, supplier, usedValuesForMethod));
    }
}

