/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.definitions;

import dev.codesoapbox.dummy4j.definitions.LocalizedDummyDefinitions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class LocalizedDummyDefinitionsMap
implements LocalizedDummyDefinitions {
    private final String locale;
    private final Map<String, Object> map;

    public LocalizedDummyDefinitionsMap(String locale, Map<String, Object> map) {
        this.locale = locale;
        this.map = map;
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    @Override
    public List<String> resolve(String key) {
        String[] keys = key.split("\\.");
        return this.resolve(this.map, keys);
    }

    private List<String> resolve(Map<String, Object> subMap, String[] keys) {
        if (!subMap.containsKey(keys[0])) {
            return Collections.emptyList();
        }
        return this.resolveResult(keys, subMap.get(keys[0]));
    }

    private List<String> resolveResult(String[] keys, Object result) {
        if (result instanceof Map) {
            String[] keysWithoutRoot = Arrays.copyOfRange(keys, 1, keys.length);
            return this.resolve((Map)result, keysWithoutRoot);
        }
        if (result instanceof List) {
            return this.toStringList((List)result);
        }
        return Collections.singletonList(String.valueOf(result));
    }

    private List<String> toStringList(List<?> result) {
        if (result.isEmpty()) {
            return result;
        }
        return result.stream().map(String::valueOf).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalizedDummyDefinitionsMap that = (LocalizedDummyDefinitionsMap)o;
        return Objects.equals(this.locale, that.locale) && Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hash(this.locale, this.map);
    }

    public String toString() {
        return "LocalizedDummyDefinitions{locale='" + this.locale + '\'' + ", map=" + this.map + '}';
    }
}

