/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.internet;

import dev.codesoapbox.dummy4j.Dummy4j;
import dev.codesoapbox.dummy4j.dummies.internet.UrlHost;
import dev.codesoapbox.dummy4j.dummies.internet.UrlProtocol;
import dev.codesoapbox.dummy4j.exceptions.UrlCouldNotBeCreatedException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;

public final class UrlBuilder {
    public static final int MIN_PORT = 1000;
    public static final int MAX_PORT = 9999;
    public static final int DEFAULT_PORT = -1;
    static final int CHANCE_OF_PARAM_VALUE_AS_STRING = 4;
    static final int CHANCE_IN_PARAM_VALUE_AS_STRING = 6;
    static final String DEFAULT_TOP_LEVEL_DOMAIN_KEY = "#{internet.top_level_domain}";
    static final String POPULAR_TOP_LEVEL_DOMAIN_KEY = "#{internet.popular_top_level_domain}";
    static final String COUNTRY_TOP_LEVEL_DOMAIN_KEY = "#{internet.country_top_level_domain}";
    static final String GENERIC_TOP_LEVEL_DOMAIN_KEY = "#{internet.generic_top_level_domain}";
    static final String ROOT_DOMAIN_KEY = "#{internet.root_domain}";
    static final String PARAM_KEY = "#{internet.param}";
    static final String PARAM_VALUE_KEY = "#{internet.param_value}";
    private static final String FILE_EXTENSION = ".html";
    private static final String PATH_DELIMITER = "/";
    private static final int FILE_NAME_LENGTH = 10;
    private final Dummy4j dummy4j;
    private List<UrlProtocol> possibleProtocols = Collections.singletonList(UrlProtocol.HTTPS);
    private int howManyParams = 0;
    private boolean withFilePath;
    private boolean withoutWwwPrefix;
    private int port = -1;
    private String domainKey = "#{internet.top_level_domain}";
    private String customTopLevelDomain;
    private int minLength;

    public UrlBuilder(Dummy4j dummy4j) {
        this.dummy4j = dummy4j;
    }

    public UrlBuilder withProtocol(UrlProtocol protocol) {
        this.possibleProtocols = Collections.singletonList(protocol);
        return this;
    }

    public UrlBuilder withRandomProtocol(UrlProtocol ... protocols) {
        this.possibleProtocols = Arrays.asList(protocols);
        return this;
    }

    public UrlBuilder withoutWwwPrefix() {
        this.withoutWwwPrefix = true;
        return this;
    }

    public UrlBuilder withPort(int port) {
        this.port = port;
        return this;
    }

    public UrlBuilder withRandomPort() {
        this.withPort(this.dummy4j.number().nextInt(1000, 9999));
        return this;
    }

    public UrlBuilder withFilePath() {
        this.withFilePath = true;
        return this;
    }

    public UrlBuilder withQueryParam() {
        this.howManyParams = 1;
        return this;
    }

    public UrlBuilder withQueryParams(int howManyParams) {
        this.validateHowManyParams(howManyParams);
        this.howManyParams = howManyParams;
        return this;
    }

    private void validateHowManyParams(int howManyParams) {
        if (howManyParams < 0) {
            String message = String.format("The specified amount of query params must be a positive number, but \"%d\" was given", howManyParams);
            throw new IllegalArgumentException(message);
        }
    }

    public UrlBuilder withTopLevelDomain(String domain) {
        this.customTopLevelDomain = domain;
        return this;
    }

    public UrlBuilder withPopularTopLevelDomain() {
        this.customTopLevelDomain = null;
        this.domainKey = POPULAR_TOP_LEVEL_DOMAIN_KEY;
        return this;
    }

    public UrlBuilder withCountryTopLevelDomain() {
        this.customTopLevelDomain = null;
        this.domainKey = COUNTRY_TOP_LEVEL_DOMAIN_KEY;
        return this;
    }

    public UrlBuilder withGenericTopLevelDomain() {
        this.customTopLevelDomain = null;
        this.domainKey = GENERIC_TOP_LEVEL_DOMAIN_KEY;
        return this;
    }

    public UrlBuilder minLength(int minLength) {
        this.minLength = minLength;
        return this;
    }

    public URL build() {
        UrlProtocol protocol = Optional.ofNullable(this.dummy4j.of(this.possibleProtocols)).orElse(this.dummy4j.nextEnum(UrlProtocol.class));
        UrlHost host = this.getUrlHost();
        String filePathAndQueryParams = this.getFilePath();
        if (this.howManyParams > 0) {
            filePathAndQueryParams = filePathAndQueryParams + this.getParams();
        }
        return this.buildUrlWithProperLength(protocol, host, filePathAndQueryParams);
    }

    private UrlHost getUrlHost() {
        String rootDomain = this.dummy4j.expressionResolver().resolve(ROOT_DOMAIN_KEY);
        if (this.customTopLevelDomain != null) {
            return new UrlHost(rootDomain, this.customTopLevelDomain, this.withoutWwwPrefix);
        }
        String topLevelDomain = this.dummy4j.expressionResolver().resolve(this.domainKey);
        return new UrlHost(rootDomain, topLevelDomain, this.withoutWwwPrefix);
    }

    private String getFilePath() {
        if (this.withFilePath) {
            return PATH_DELIMITER + this.dummy4j.lorem().characters(10) + FILE_EXTENSION;
        }
        return "";
    }

    private String getParams() {
        StringJoiner path = new StringJoiner("&", "?", "");
        for (int i = 0; i < this.howManyParams; ++i) {
            path.add(this.dummy4j.expressionResolver().resolve(PARAM_KEY) + "=" + this.generateParamValue());
        }
        return path.toString();
    }

    private String generateParamValue() {
        if (this.dummy4j.chance(4, 6)) {
            return this.dummy4j.expressionResolver().resolve(PARAM_VALUE_KEY);
        }
        return String.valueOf(this.dummy4j.number().nextInt());
    }

    private URL buildUrlWithProperLength(UrlProtocol protocol, UrlHost host, String filePath) {
        URL url = this.buildUrl(protocol, host, filePath);
        int urlLength = url.toString().length();
        if (urlLength >= this.minLength) {
            return url;
        }
        int missingLength = this.minLength - urlLength;
        return this.buildUrlAdjustedForLength(protocol, host, filePath, missingLength);
    }

    private URL buildUrl(UrlProtocol protocol, UrlHost host, String filePath) {
        try {
            return new URL(protocol.getValue(), host.toString(), this.port, filePath);
        }
        catch (MalformedURLException e) {
            throw new UrlCouldNotBeCreatedException(e);
        }
    }

    private URL buildUrlAdjustedForLength(UrlProtocol protocol, UrlHost host, String filePath, int missingLength) {
        if (this.withFilePath && this.howManyParams == 0) {
            filePath = this.increaseFileNameLength(filePath, missingLength);
        } else if (this.howManyParams > 0) {
            filePath = this.increaseLastParamValueLength(filePath, missingLength);
        } else {
            host = this.increaseRootDomainLength(host, missingLength);
        }
        return this.buildUrl(protocol, host, filePath);
    }

    private String increaseFileNameLength(String filePath, int missingLength) {
        String withoutExtension = filePath.substring(0, filePath.length() - FILE_EXTENSION.length());
        String extraCharacters = this.dummy4j.lorem().characters(missingLength);
        return withoutExtension + extraCharacters + FILE_EXTENSION;
    }

    private String increaseLastParamValueLength(String filePath, int missingLength) {
        return filePath + this.dummy4j.lorem().characters(missingLength);
    }

    private UrlHost increaseRootDomainLength(UrlHost host, int missingLength) {
        String rootDomain = host.getRootDomain() + this.dummy4j.lorem().characters(missingLength);
        host = new UrlHost(rootDomain, host.getTopLevelDomain(), this.withoutWwwPrefix);
        return host;
    }

    public String toString() {
        return "UrlBuilder{possibleProtocols=" + this.possibleProtocols + ", howManyParams=" + this.howManyParams + ", withFilePath=" + this.withFilePath + ", withoutWwwPrefix=" + this.withoutWwwPrefix + ", port=" + this.port + ", domainKey='" + this.domainKey + '\'' + ", customTopLevelDomain='" + this.customTopLevelDomain + '\'' + ", minLength=" + this.minLength + '}';
    }
}

