/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.internet;

import dev.codesoapbox.dummy4j.Dummy4j;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;

public class PasswordBuilder {
    public static final int DIGIT_UPPER_BOUND = 9;
    public static final String SPECIAL_CHAR_KEY = "#{internet.password_special_char}";
    private final Dummy4j dummy4j;
    private final Map<String, Supplier<Character>> constraintCharacters = new LinkedHashMap<String, Supplier<Character>>();
    private int minLength = 12;
    private int maxLength = 12;

    public PasswordBuilder(Dummy4j dummy4j) {
        this.dummy4j = dummy4j;
    }

    public PasswordBuilder withDigits() {
        this.constraintCharacters.put("with digits", this::getDigit);
        return this;
    }

    private Character getDigit() {
        int number = this.dummy4j.number().nextInt(9);
        return Character.valueOf((char)(number + 48));
    }

    public PasswordBuilder withSpecialChars() {
        this.constraintCharacters.put("with special characters", this::getSpecialChar);
        return this;
    }

    private Character getSpecialChar() {
        return Character.valueOf(this.dummy4j.expressionResolver().resolve(SPECIAL_CHAR_KEY).charAt(0));
    }

    public PasswordBuilder withUpperCaseChars() {
        this.constraintCharacters.put("with upper case characters", this::getUpperCaseChar);
        return this;
    }

    private Character getUpperCaseChar() {
        return Character.valueOf(this.dummy4j.lorem().character().toUpperCase(Locale.ENGLISH).charAt(0));
    }

    public PasswordBuilder withLength(int length) {
        this.minLength = length;
        this.maxLength = length;
        return this;
    }

    public PasswordBuilder withMinLength(int minLength) {
        if (minLength > this.maxLength) {
            this.maxLength = minLength;
        }
        this.minLength = minLength;
        return this;
    }

    public PasswordBuilder withMaxLength(int maxLength) {
        if (maxLength < this.minLength) {
            this.minLength = maxLength;
        }
        this.maxLength = maxLength;
        return this;
    }

    public String build() {
        this.verifyMinLengthCanAccommodateConstraints();
        return this.applyConstraints(this.getPasswordWithOnlyLetters());
    }

    private void verifyMinLengthCanAccommodateConstraints() {
        if (this.constraintCharacters.size() >= this.minLength) {
            String selectedConstraints = String.join((CharSequence)", ", this.constraintCharacters.keySet());
            throw new IllegalArgumentException("Minimum length of the password (" + this.minLength + ") must be GREATER than the number of selected constraints (" + this.constraintCharacters.size() + "). The following constraints were selected: [" + selectedConstraints + "].");
        }
    }

    private String applyConstraints(String password) {
        int offset = 0;
        int howManyCharsToSkip = this.constraintCharacters.size() + 1;
        StringBuilder passwordWithConstraints = new StringBuilder(password);
        for (Supplier<Character> supplier : this.constraintCharacters.values()) {
            for (int i = offset; i < password.length(); i += howManyCharsToSkip) {
                passwordWithConstraints.setCharAt(i, supplier.get().charValue());
            }
            ++offset;
        }
        return passwordWithConstraints.toString();
    }

    private String getPasswordWithOnlyLetters() {
        int length = this.dummy4j.number().nextInt(this.minLength, this.maxLength);
        return this.dummy4j.lorem().characters(length);
    }

    public String toString() {
        return "PasswordBuilder{constraintCharacters=" + this.constraintCharacters.keySet() + ", minLength=" + this.minLength + ", maxLength=" + this.maxLength + '}';
    }
}

