/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.finance;

import dev.codesoapbox.dummy4j.dummies.shared.string.Padding;

public class IbanFormula {
    private static final int MOD = 97;
    private static final int CHECK_SUM = 98;
    private static final String CHECK_DIGIT_REPLACEMENT = "00";
    private static final int MIN_NUMERIC_CHAR = 10;
    private static final int ONE_PLACE = 10;
    private static final int TWO_PLACES = 100;
    private static final int MAX_FOR_EIGHT_DIGITS = 99999999;

    String generateCheckDigits(String accountNumber, String countryCode) {
        int modulus = this.getModulusForNumericValues(accountNumber + countryCode + CHECK_DIGIT_REPLACEMENT);
        int checkDigit = 98 - modulus;
        return Padding.leftPad(String.valueOf(checkDigit), 2, '0');
    }

    private int getModulusForNumericValues(String input) {
        long value = 0L;
        char[] cArray = input.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            int numericValue;
            Character character = Character.valueOf(cArray[i]);
            if (!Character.isLetterOrDigit(character.charValue()) || !this.isNineDigitsLong(value = this.addDigitsToTheRightSide(value, numericValue = this.getNumericValue(character)))) continue;
            value %= 97L;
        }
        return (int)(value % 97L);
    }

    private int getNumericValue(Character character) {
        char lowerCaseChar = Character.toLowerCase(character.charValue());
        return Character.getNumericValue(lowerCaseChar);
    }

    private long addDigitsToTheRightSide(long originalValue, int digits) {
        if (this.isLetter(digits)) {
            return this.allocateSpace(originalValue, 100) + (long)digits;
        }
        return this.allocateSpace(originalValue, 10) + (long)digits;
    }

    private boolean isLetter(int characterNumericValue) {
        return characterNumericValue >= 10;
    }

    private long allocateSpace(long originalValue, int howMuch) {
        return originalValue * (long)howMuch;
    }

    private boolean isNineDigitsLong(long value) {
        return value > 99999999L;
    }
}

