/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.finance;

import dev.codesoapbox.dummy4j.Dummy4j;
import dev.codesoapbox.dummy4j.dummies.finance.BankAccountCountry;
import dev.codesoapbox.dummy4j.dummies.finance.IbanFormula;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Pattern;

public class IbanBuilder {
    private static final Pattern SPLIT_EVERY_FOUR_CHARS_PATTERN = Pattern.compile("(?<=\\G.{4})");
    private final Dummy4j dummy4j;
    private final IbanFormula ibanFormula;
    private List<BankAccountCountry> countries = Collections.emptyList();
    private boolean formatted;

    public IbanBuilder(Dummy4j dummy4j, IbanFormula ibanFormula) {
        this.dummy4j = dummy4j;
        this.ibanFormula = ibanFormula;
    }

    public IbanBuilder withRandomCountry() {
        this.countries = Collections.emptyList();
        return this;
    }

    public IbanBuilder withRandomCountry(BankAccountCountry ... countries) {
        this.countries = Arrays.asList(countries);
        return this;
    }

    public IbanBuilder withCountry(BankAccountCountry country) {
        this.countries = Collections.singletonList(country);
        return this;
    }

    public IbanBuilder formatted() {
        this.formatted = true;
        return this;
    }

    public String build() {
        BankAccountCountry country = Optional.ofNullable(this.dummy4j.of(this.countries)).orElse(this.dummy4j.nextEnum(BankAccountCountry.class));
        String account = this.dummy4j.finance().bankAccountNumber(country);
        String countryCode = country.getCode();
        String iban = countryCode + this.ibanFormula.generateCheckDigits(account, countryCode) + account;
        return this.format(iban);
    }

    private String format(String iban) {
        if (!this.formatted) {
            return iban;
        }
        return this.splitEveryFourCharacters(iban);
    }

    private String splitEveryFourCharacters(String input) {
        String[] parts = SPLIT_EVERY_FOUR_CHARS_PATTERN.split(input);
        StringJoiner joiner = new StringJoiner(" ");
        for (String p : parts) {
            joiner.add(p);
        }
        return joiner.toString();
    }

    public String toString() {
        return "IbanBuilder{countries=" + this.countries + ", formatted=" + this.formatted + '}';
    }
}

