/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.finance;

import dev.codesoapbox.dummy4j.Dummy4j;
import dev.codesoapbox.dummy4j.dummies.finance.BankAccountCountry;
import dev.codesoapbox.dummy4j.dummies.finance.CreditCard;
import dev.codesoapbox.dummy4j.dummies.finance.CreditCardBuilder;
import dev.codesoapbox.dummy4j.dummies.finance.CreditCardNumberBuilder;
import dev.codesoapbox.dummy4j.dummies.finance.CreditCardProvider;
import dev.codesoapbox.dummy4j.dummies.finance.FinanceBuilderFactory;
import dev.codesoapbox.dummy4j.dummies.finance.IbanBuilder;
import dev.codesoapbox.dummy4j.dummies.finance.PriceBuilder;
import java.util.regex.Pattern;

public class FinanceDummy {
    static final String CURRENCY_CODE_KEY = "#{finance.currency.code}";
    static final String CURRENCY_NUMERIC_CODE_KEY = "#{finance.currency.numeric_code}";
    static final String CURRENCY_NAME_KEY = "#{finance.currency.name}";
    static final String CURRENCY_SYMBOL_KEY = "#{finance.currency.symbol}";
    static final String CRYPTO_CURRENCY_CODE_KEY = "#{finance.cryptocurrency.code}";
    static final String CRYPTO_CURRENCY_NAME_KEY = "#{finance.cryptocurrency.name}";
    static final String CRYPTO_CURRENCY_SYMBOL_KEY = "#{finance.cryptocurrency.symbol}";
    static final String BANK_ACCOUNT_TYPE_KEY = "#{finance.bank_account.type}";
    static final String BANK_ACCOUNT_LETTER_KEY = "#{finance.bank_account.letter}";
    static final Pattern BANK_ACCOUNT_LETTER_PLACEHOLDER_PATTERN = Pattern.compile("_");
    static final String PARTIAL_ACCOUNT_NUMBER_KEY = "#{finance.bank_account.number_structure.";
    static final String PAYMENT_OPTION_KEY = "#{finance.bank_account.payment_option}";
    static final String FINANCIAL_OPERATION_KEY = "#{finance.bank_account.financial_operation}";
    static final String BITCOIN_ADDRESS_FORMAT_KEY = "#{finance.bank_account.bitcoin_address.format}";
    static final String BITCOIN_ADDRESS_CHARACTERS_KEY = "#{finance.bank_account.bitcoin_address.characters}";
    static final int BITCOIN_ADDRESS_MIN_LENGTH = 26;
    static final int BITCOIN_ADDRESS_MAX_LENGTH = 35;
    private final Dummy4j dummy4j;
    private final FinanceBuilderFactory financeBuilderFactory;

    public FinanceDummy(Dummy4j dummy4j, FinanceBuilderFactory financeBuilderFactory) {
        this.dummy4j = dummy4j;
        this.financeBuilderFactory = financeBuilderFactory;
    }

    public String price() {
        return new PriceBuilder(this.dummy4j).build();
    }

    public PriceBuilder priceBuilder() {
        return new PriceBuilder(this.dummy4j);
    }

    public String currencyCode() {
        return this.dummy4j.expressionResolver().resolve(CURRENCY_CODE_KEY);
    }

    public String currencyNumericCode() {
        return this.dummy4j.expressionResolver().resolve(CURRENCY_NUMERIC_CODE_KEY);
    }

    public String currencyName() {
        return this.dummy4j.expressionResolver().resolve(CURRENCY_NAME_KEY);
    }

    public String currencySymbol() {
        return this.dummy4j.expressionResolver().resolve(CURRENCY_SYMBOL_KEY);
    }

    public String cryptoCurrencyCode() {
        return this.dummy4j.expressionResolver().resolve(CRYPTO_CURRENCY_CODE_KEY);
    }

    public String cryptoCurrencyName() {
        return this.dummy4j.expressionResolver().resolve(CRYPTO_CURRENCY_NAME_KEY);
    }

    public String cryptoCurrencySymbol() {
        return this.dummy4j.expressionResolver().resolve(CRYPTO_CURRENCY_SYMBOL_KEY);
    }

    public CreditCardProvider creditCardProvider() {
        return this.dummy4j.nextEnum(CreditCardProvider.class);
    }

    public String creditCardNumber() {
        return this.financeBuilderFactory.createCreditCardNumberBuilder().build();
    }

    public CreditCardNumberBuilder creditCardNumberBuilder() {
        return this.financeBuilderFactory.createCreditCardNumberBuilder();
    }

    public CreditCard creditCard() {
        return this.financeBuilderFactory.createCreditCardBuilder().build();
    }

    public CreditCardBuilder creditCardBuilder() {
        return this.financeBuilderFactory.createCreditCardBuilder();
    }

    public String bic() {
        String bankCode = this.getBankAccountLetters(4);
        String countryCode = this.dummy4j.nation().countryCode();
        String locationCode = this.getBankAccountLetters(2);
        String branchCode = String.valueOf(this.dummy4j.number().nextInt(100, 999));
        return bankCode + countryCode + locationCode + branchCode;
    }

    private String getBankAccountLetters(int howMany) {
        StringBuilder code = new StringBuilder();
        for (int i = 0; i < howMany; ++i) {
            code.append(this.dummy4j.expressionResolver().resolve(BANK_ACCOUNT_LETTER_KEY));
        }
        return code.toString();
    }

    public String bankAccountNumber(BankAccountCountry country) {
        String key = PARTIAL_ACCOUNT_NUMBER_KEY + country.getCode() + "}";
        String numbers = this.dummy4j.expressionResolver().resolve(key);
        return BANK_ACCOUNT_LETTER_PLACEHOLDER_PATTERN.matcher(numbers).replaceAll(this.dummy4j.expressionResolver().resolve(BANK_ACCOUNT_LETTER_KEY));
    }

    public String iban() {
        return this.financeBuilderFactory.createIbanBuilder().build();
    }

    public IbanBuilder ibanBuilder() {
        return this.financeBuilderFactory.createIbanBuilder();
    }

    public String bankAccountType() {
        return this.dummy4j.expressionResolver().resolve(BANK_ACCOUNT_TYPE_KEY);
    }

    public String paymentOption() {
        return this.dummy4j.expressionResolver().resolve(PAYMENT_OPTION_KEY);
    }

    public String financialOperation() {
        return this.dummy4j.expressionResolver().resolve(FINANCIAL_OPERATION_KEY);
    }

    public String bitcoinAddress() {
        String format = this.dummy4j.expressionResolver().resolve(BITCOIN_ADDRESS_FORMAT_KEY);
        String characters = this.getBitcoinAddressChars(format.length());
        return format + characters;
    }

    private String getBitcoinAddressChars(int formatLength) {
        int length = this.dummy4j.number().nextInt(26 - formatLength, 35 - formatLength);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(this.dummy4j.expressionResolver().resolve(BITCOIN_ADDRESS_CHARACTERS_KEY).toCharArray()[0]);
        }
        return builder.toString();
    }
}

