/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.finance;

import dev.codesoapbox.dummy4j.dummies.address.Address;
import dev.codesoapbox.dummy4j.dummies.finance.CreditCardProvider;
import dev.codesoapbox.dummy4j.dummies.shared.string.StringValidator;
import java.util.Objects;
import java.util.StringJoiner;

public final class CreditCard {
    private final String number;
    private final CreditCardProvider provider;
    private final String ownerName;
    private final Address ownerAddress;
    private final String expiryDate;
    private final String securityCode;

    CreditCard(String number, CreditCardProvider provider, String ownerName, Address ownerAddress, String expiryDate, String securityCode) {
        this.number = number;
        this.provider = provider;
        this.ownerName = ownerName;
        this.ownerAddress = ownerAddress;
        this.expiryDate = expiryDate;
        this.securityCode = securityCode;
        this.validateFields();
    }

    private void validateFields() {
        String fields;
        StringJoiner missingFields = new StringJoiner(", ");
        if (StringValidator.isNullOrEmpty(this.number)) {
            missingFields.add("number");
        }
        if (StringValidator.isNullOrEmpty(this.ownerName)) {
            missingFields.add("ownerName");
        }
        if (StringValidator.isNullOrEmpty(this.expiryDate)) {
            missingFields.add("expiryDate");
        }
        if (StringValidator.isNullOrEmpty(this.securityCode)) {
            missingFields.add("securityCode");
        }
        if (this.provider == null) {
            missingFields.add("provider");
        }
        if (this.ownerAddress == null) {
            missingFields.add("owner address");
        }
        if (!(fields = missingFields.toString()).isEmpty()) {
            throw new IllegalArgumentException("Missing values for the following fields: " + fields);
        }
    }

    public String getNumber() {
        return this.number;
    }

    public CreditCardProvider getProvider() {
        return this.provider;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public Address getOwnerAddress() {
        return this.ownerAddress;
    }

    public String getExpiryDate() {
        return this.expiryDate;
    }

    public String getSecurityCode() {
        return this.securityCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreditCard)) {
            return false;
        }
        CreditCard that = (CreditCard)o;
        return this.number.equals(that.number) && this.provider == that.provider && this.ownerName.equals(that.ownerName) && this.ownerAddress.equals(that.ownerAddress) && this.expiryDate.equals(that.expiryDate) && this.securityCode.equals(that.securityCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.number, this.provider, this.ownerName, this.ownerAddress, this.expiryDate, this.securityCode});
    }

    public String toString() {
        return "CreditCard{number='" + this.number + '\'' + ", provider=" + this.provider.getName() + ", ownerName='" + this.ownerName + '\'' + ", ownerAddress='" + this.ownerAddress + '\'' + ", expiryDate='" + this.expiryDate + '\'' + ", securityCode='" + this.securityCode + '\'' + '}';
    }
}

