/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.color;

import dev.codesoapbox.dummy4j.dummies.shared.math.NumberFormatter;
import dev.codesoapbox.dummy4j.dummies.shared.math.NumberValidator;
import dev.codesoapbox.dummy4j.dummies.shared.math.Round;
import java.util.Objects;

public final class CMYK {
    private final float cyan;
    private final float magenta;
    private final float yellow;
    private final float black;

    public CMYK(float cyan, float magenta, float yellow, float black) {
        this.validate(cyan, magenta, yellow, black);
        this.cyan = Round.toTwoDecimals(cyan);
        this.magenta = Round.toTwoDecimals(magenta);
        this.yellow = Round.toTwoDecimals(yellow);
        this.black = Round.toTwoDecimals(black);
    }

    private void validate(float cyan, float magenta, float yellow, float black) {
        NumberValidator.betweenZeroAndOne(cyan);
        NumberValidator.betweenZeroAndOne(magenta);
        NumberValidator.betweenZeroAndOne(yellow);
        NumberValidator.betweenZeroAndOne(black);
    }

    public float getCyan() {
        return this.cyan;
    }

    public float getMagenta() {
        return this.magenta;
    }

    public float getYellow() {
        return this.yellow;
    }

    public float getBlack() {
        return this.black;
    }

    public float[] toArray() {
        return new float[]{this.cyan, this.magenta, this.yellow, this.black};
    }

    public String toString() {
        return "cmyk(" + NumberFormatter.toPercent(this.cyan) + ", " + NumberFormatter.toPercent(this.magenta) + ", " + NumberFormatter.toPercent(this.yellow) + ", " + NumberFormatter.toPercent(this.black) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CMYK cmyk = (CMYK)o;
        return Float.compare(cmyk.cyan, this.cyan) == 0 && Float.compare(cmyk.magenta, this.magenta) == 0 && Float.compare(cmyk.yellow, this.yellow) == 0 && Float.compare(cmyk.black, this.black) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.cyan), Float.valueOf(this.magenta), Float.valueOf(this.yellow), Float.valueOf(this.black));
    }
}

