/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.address;

import dev.codesoapbox.dummy4j.dummies.shared.string.StringValidator;
import java.util.Objects;
import java.util.StringJoiner;

public final class Address {
    private final String street;
    private final String postCode;
    private final String city;
    private final String country;

    public Address(String street, String postCode, String city, String country) {
        this.street = street;
        this.postCode = postCode;
        this.city = city;
        this.country = country;
        this.validateFields();
    }

    private void validateFields() {
        String fields;
        StringJoiner missingFields = new StringJoiner(", ");
        if (StringValidator.isNullOrEmpty(this.street)) {
            missingFields.add("street");
        }
        if (StringValidator.isNullOrEmpty(this.postCode)) {
            missingFields.add("post code");
        }
        if (StringValidator.isNullOrEmpty(this.city)) {
            missingFields.add("city");
        }
        if (StringValidator.isNullOrEmpty(this.country)) {
            missingFields.add("country");
        }
        if (!(fields = missingFields.toString()).isEmpty()) {
            throw new IllegalArgumentException("Missing values for the following fields: " + fields);
        }
    }

    public String getStreet() {
        return this.street;
    }

    public String getPostCode() {
        return this.postCode;
    }

    public String getCity() {
        return this.city;
    }

    public String getCountry() {
        return this.country;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address address = (Address)o;
        return this.street.equals(address.street) && this.postCode.equals(address.postCode) && this.city.equals(address.city) && this.country.equals(address.country);
    }

    public int hashCode() {
        return Objects.hash(this.street, this.postCode, this.city, this.country);
    }

    public String toString() {
        return this.street + ", " + this.postCode + " " + this.city + ", " + this.country;
    }
}

