/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies;

import dev.codesoapbox.dummy4j.Dummy4j;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;

public class DateAndTimeDummy {
    private static final int DEFAULT_MIN_AGE = 18;
    private static final int DEFAULT_MAX_AGE = 80;
    private static final String END_MUST_NOT_PRECEDE_START = "End date must not precede start date";
    private static final String MAX_AGE_MUST_BE_GREATER_OR_EQUAL_MIN_AGE = "Max age must be greater or equal min age";
    private static final String AGE_MUST_BE_POSITIVE = "Given age must be a positive number";
    private static final String AT_MOST_MUST_BE_POSITIVE = "At most must be a positive number";
    private final Dummy4j dummy4j;
    private final Clock clock;

    public DateAndTimeDummy(Dummy4j dummy4j, Clock clock) {
        this.dummy4j = dummy4j;
        this.clock = clock;
    }

    public LocalDateTime any() {
        return LocalDateTime.ofEpochSecond(this.dummy4j.number().nextLong(), 0, ZoneOffset.UTC);
    }

    public LocalDate birthday() {
        return this.birthday(18, 80);
    }

    public LocalDate birthday(int age) {
        return this.birthday(age, age);
    }

    public LocalDate birthday(int minAge, int maxAge) {
        if (minAge < 0 || maxAge < 0) {
            throw new IllegalArgumentException(AGE_MUST_BE_POSITIVE);
        }
        if (maxAge < minAge) {
            throw new IllegalArgumentException(MAX_AGE_MUST_BE_GREATER_OR_EQUAL_MIN_AGE);
        }
        LocalDate minDate = LocalDate.now(this.clock).minus((long)maxAge + 1L, ChronoUnit.YEARS).plus(1L, ChronoUnit.DAYS);
        LocalDate maxDate = LocalDate.now(this.clock).minus(minAge, ChronoUnit.YEARS);
        return this.between(minDate, maxDate);
    }

    public LocalDateTime between(LocalDateTime start, LocalDateTime end) {
        if (end.isBefore(start)) {
            throw new IllegalArgumentException(END_MUST_NOT_PRECEDE_START);
        }
        long startEpoch = start.toEpochSecond(ZoneOffset.UTC);
        long endEpoch = end.toEpochSecond(ZoneOffset.UTC);
        long randomEpochSecond = this.nextLongWithNegativeBounds(startEpoch, endEpoch);
        return LocalDateTime.ofEpochSecond(randomEpochSecond, 0, ZoneOffset.UTC);
    }

    public LocalDate between(LocalDate start, LocalDate end) {
        if (end.isBefore(start)) {
            throw new IllegalArgumentException(END_MUST_NOT_PRECEDE_START);
        }
        long randomDay = this.nextLongWithNegativeBounds(start.toEpochDay(), end.toEpochDay());
        return LocalDate.ofEpochDay(randomDay);
    }

    private long nextLongWithNegativeBounds(long lowerBound, long upperBound) {
        long diff = Math.abs(lowerBound - upperBound);
        return this.dummy4j.number().nextLong(0L, diff) + lowerBound;
    }

    public LocalDateTime past(long atMost, ChronoUnit unit) {
        if (atMost < 0L) {
            throw new IllegalArgumentException(AT_MOST_MUST_BE_POSITIVE);
        }
        return LocalDateTime.now(this.clock).minus(this.dummy4j.number().nextLong(0L, atMost), unit);
    }

    public LocalDateTime before(LocalDateTime referenceDate, long atMost, ChronoUnit unit) {
        if (atMost < 0L) {
            throw new IllegalArgumentException(AT_MOST_MUST_BE_POSITIVE);
        }
        return referenceDate.minus(this.dummy4j.number().nextLong(0L, atMost), unit);
    }

    public LocalDateTime future(long atMost, ChronoUnit unit) {
        if (atMost < 0L) {
            throw new IllegalArgumentException(AT_MOST_MUST_BE_POSITIVE);
        }
        return LocalDateTime.now(this.clock).plus(this.dummy4j.number().nextLong(0L, atMost), unit);
    }

    public LocalDateTime after(LocalDateTime referenceDate, long atMost, ChronoUnit unit) {
        if (atMost < 0L) {
            throw new IllegalArgumentException(AT_MOST_MUST_BE_POSITIVE);
        }
        return referenceDate.plus(this.dummy4j.number().nextLong(0L, atMost), unit);
    }
}

