/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.definitions.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MapMerger {
    public Map<String, Object> merge(List<Map<String, Object>> definitionMaps) {
        HashMap<String, Object> target = new HashMap<String, Object>();
        definitionMaps.forEach(otherMap -> this.mergeMap((Map<String, Object>)target, (Map<String, Object>)otherMap));
        return target;
    }

    private Map<String, Object> mergeMap(Map<String, Object> targetMap, Map<String, Object> otherMap) {
        otherMap.forEach((key, value) -> this.mergeMapKey(targetMap, otherMap, (String)key, value));
        return targetMap;
    }

    private void mergeMapKey(Map<String, Object> targetMap, Map<String, Object> otherMap, String key, Object value) {
        if (!targetMap.containsKey(key)) {
            targetMap.put(key, value);
            return;
        }
        Object targetValue = targetMap.get(key);
        Object otherValue = otherMap.get(key);
        if (targetValue instanceof String) {
            List<?> result = this.mergeStringWithObject((String)targetValue, otherValue);
            targetMap.put(key, result);
        } else if (targetValue instanceof Map) {
            Map<String, Object> result = this.mergeMap(new HashMap<String, Object>((Map)targetValue), (Map)otherValue);
            targetMap.put(key, result);
        } else {
            Collection<?> result = this.mergeCollectionWithOtherObject((Collection)targetValue, otherValue);
            targetMap.put(key, result);
        }
    }

    private Collection<?> mergeCollectionWithOtherObject(Collection<String> targetValue, Object otherValue) {
        if (otherValue instanceof String) {
            return this.addToEndOfCollection(targetValue, (String)otherValue);
        }
        return this.mergeListsOfStrings(targetValue, (Collection)otherValue);
    }

    private List<?> mergeStringWithObject(String targetValue, Object otherValue) {
        if (otherValue instanceof String) {
            return Arrays.asList(targetValue, otherValue);
        }
        return this.addToBeginningOfCollection(targetValue, (Collection)otherValue);
    }

    private List<String> addToBeginningOfCollection(String element, Collection<String> collection) {
        ArrayList<String> mergedList = new ArrayList<String>();
        mergedList.add(element);
        mergedList.addAll(collection);
        return mergedList;
    }

    private List<String> addToEndOfCollection(Collection<String> collection, String element) {
        ArrayList<String> mergedList = new ArrayList<String>(collection);
        mergedList.add(element);
        return mergedList;
    }

    private List<String> mergeListsOfStrings(Collection<String> targetValue, Collection<String> otherValue) {
        return Stream.concat(targetValue.stream(), otherValue.stream()).distinct().collect(Collectors.toList());
    }
}

