/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.definitions;

import dev.codesoapbox.dummy4j.annotations.Experimental;
import dev.codesoapbox.dummy4j.exceptions.UniqueValueRetryLimitExceededException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

@Experimental
public class UniqueValues {
    private final Map<String, Set<Object>> usedValues = new HashMap<String, Set<Object>>();
    private int maxRetries = 10000;

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public <T> T value(String uniquenessGroup, Supplier<T> supplier) {
        Set usedValuesForMethod = this.usedValues.computeIfAbsent(uniquenessGroup, k -> new HashSet());
        for (int i = 0; i <= this.maxRetries; ++i) {
            T result = supplier.get();
            if (usedValuesForMethod.contains(result)) continue;
            usedValuesForMethod.add(result);
            return result;
        }
        throw new UniqueValueRetryLimitExceededException(this.maxRetries, uniquenessGroup);
    }
}

