/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j;

import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;

public class RandomService {
    private static final String UPPER_BOUND_MUST_BE_POSITIVE = "Upper bound must be positive or zero";
    private static final String LOWER_BOUND_MUST_BE_POSITIVE = "Lower bound must be positive or zero";
    private final long seed;
    private final Random random;

    public RandomService() {
        this(null);
    }

    public RandomService(Long seed) {
        this.seed = seed != null ? seed : (long)ThreadLocalRandom.current().nextInt();
        this.random = new Random(this.seed);
    }

    public long getSeed() {
        return this.seed;
    }

    public <T> T chance(int howMany, int in, Supplier<T> supplier) {
        if (this.nextInt(1, in) > howMany) {
            return null;
        }
        return supplier.get();
    }

    public <T extends Enum<?>> T enumValue(Class<T> clazz) {
        int x = this.nextInt(((Enum[])clazz.getEnumConstants()).length);
        return (T)((Enum[])clazz.getEnumConstants())[x];
    }

    public String uuid() {
        return UUID.nameUUIDFromBytes(String.valueOf(this.nextLong()).getBytes(StandardCharsets.UTF_8)).toString();
    }

    public boolean nextBoolean() {
        return this.random.nextBoolean();
    }

    public int nextInt() {
        return this.random.nextInt() & Integer.MAX_VALUE;
    }

    public int nextInt(int upperBound) {
        return this.nextInt(0, upperBound);
    }

    public int nextInt(int lowerBound, int upperBound) {
        return lowerBound + this.random.nextInt(upperBound - lowerBound + 1);
    }

    public long nextLong() {
        return this.random.nextLong() & Long.MAX_VALUE;
    }

    public long nextLong(long lowerBound, long upperBound) {
        return lowerBound + this.nextLong(upperBound - lowerBound);
    }

    public long nextLong(long upperBound) {
        long val;
        long bits;
        if (upperBound < 0L) {
            throw new IllegalArgumentException(UPPER_BOUND_MUST_BE_POSITIVE);
        }
        while ((bits = this.random.nextLong() << 1 >>> 1) - (val = bits % upperBound + 1L) + upperBound < 0L) {
        }
        return val;
    }

    public double nextDouble() {
        return this.random.nextDouble();
    }

    public double nextDouble(double bound) {
        return this.nextDouble(0.0, bound);
    }

    public double nextDouble(double lowerBound, double upperBound) {
        if (lowerBound < 0.0) {
            throw new IllegalArgumentException(LOWER_BOUND_MUST_BE_POSITIVE);
        }
        if (upperBound < 0.0) {
            throw new IllegalArgumentException(UPPER_BOUND_MUST_BE_POSITIVE);
        }
        return lowerBound + (upperBound - lowerBound) * this.random.nextDouble();
    }

    public float nextFloat() {
        return this.random.nextFloat();
    }

    public float nextFloat(float upperBound) {
        return this.nextFloat(0.0f, upperBound);
    }

    public float nextFloat(float lowerBound, float upperBound) {
        if (lowerBound < 0.0f) {
            throw new IllegalArgumentException(LOWER_BOUND_MUST_BE_POSITIVE);
        }
        if (upperBound < 0.0f) {
            throw new IllegalArgumentException(UPPER_BOUND_MUST_BE_POSITIVE);
        }
        return this.random.nextFloat() * (upperBound - lowerBound) + lowerBound;
    }
}

