/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.shared.string;

public final class StringFormatter {
    private StringFormatter() {
    }

    public static String insertEveryNthCharacter(String originalInput, String separator, int everyN) {
        if (StringFormatter.cannotPerformInsertion(originalInput, separator, everyN)) {
            return originalInput;
        }
        char[] input = originalInput.toCharArray();
        if (input.length <= everyN) {
            return originalInput;
        }
        return StringFormatter.performInsertion(separator, everyN, input);
    }

    private static boolean cannotPerformInsertion(String originalInput, String separator, int everyN) {
        return everyN <= 0 || StringFormatter.isNullOrEmpty(originalInput) || StringFormatter.isNullOrEmpty(separator);
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    private static String performInsertion(String insertion, int everyN, char[] input) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < input.length; ++i) {
            stringBuilder.append(input[i]);
            if (!StringFormatter.isNthCharacter(i, everyN) || !StringFormatter.isNotLastCharacter(i, input)) continue;
            stringBuilder.append(insertion);
        }
        return stringBuilder.toString();
    }

    private static boolean isNthCharacter(int index, int n) {
        return (index + 1) % n == 0;
    }

    private static boolean isNotLastCharacter(int index, char[] input) {
        return index < input.length - 1;
    }
}

