/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.shared.math;

import dev.codesoapbox.dummy4j.exceptions.InvalidRangeException;
import dev.codesoapbox.dummy4j.exceptions.ValueOutOfRangeException;

public final class NumberValidator {
    private NumberValidator() {
    }

    public static void betweenZeroAndOne(float value) {
        if (value < 0.0f || value > 1.0f) {
            throw new ValueOutOfRangeException(value, 0.0f, 1.0f);
        }
    }

    public static void inRange(float value, float min, float max) {
        if (min > max) {
            throw new InvalidRangeException(min, max);
        }
        if (value < min || value > max) {
            throw new ValueOutOfRangeException(value, min, max);
        }
    }
}

