/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.shared.checkdigitformulas;

import java.util.regex.Pattern;

public class ModTenFormula {
    private static final Pattern NON_DIGIT_CHARS_PATTERN = Pattern.compile("[^\\d]");
    private static final int WEIGHT_1 = 1;
    private static final int WEIGHT_3 = 3;
    private static final int MOD = 10;

    public Integer generateCheckDigit(String input) {
        char[] sanitizedInput = this.removeInvalidCharacters(input);
        int sum = this.sumElementsMultipliedByTheirWeight(sanitizedInput);
        return this.computeCheckDigit(sum);
    }

    private char[] removeInvalidCharacters(String input) {
        return NON_DIGIT_CHARS_PATTERN.matcher(input).replaceAll("").toCharArray();
    }

    private int sumElementsMultipliedByTheirWeight(char[] input) {
        int sum = 0;
        int completeLength = input.length;
        for (int i = 0; i < input.length; ++i) {
            int positionCountedFromRight = completeLength - i;
            sum += Character.getNumericValue(input[i]) * this.getWeight(positionCountedFromRight);
        }
        return sum;
    }

    private int getWeight(int position) {
        if (position % 2 == 0) {
            return 1;
        }
        return 3;
    }

    private int computeCheckDigit(int sum) {
        int modulus = sum % 10;
        if (modulus != 0) {
            return 10 - modulus;
        }
        return 0;
    }
}

