/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.shared.checkdigitformulas;

import java.util.regex.Pattern;

public class ModElevenFormula {
    private static final Pattern NON_DIGIT_CHARS_PATTERN = Pattern.compile("[^\\d]");
    private static final int MOD = 11;

    public Integer generateCheckDigit(String input) {
        char[] sanitizedInput = this.removeInvalidCharacters(input);
        int sum = this.sumElementsMultipliedByTheirPositions(sanitizedInput);
        return this.computeCheckDigit(sum);
    }

    private char[] removeInvalidCharacters(String input) {
        return NON_DIGIT_CHARS_PATTERN.matcher(input).replaceAll("").toCharArray();
    }

    private int sumElementsMultipliedByTheirPositions(char[] input) {
        int sum = 0;
        int completeLength = input.length + 1;
        for (int i = 0; i < input.length; ++i) {
            int positionCountedFromRight = completeLength - i;
            sum += Character.getNumericValue(input[i]) * positionCountedFromRight;
        }
        return sum;
    }

    private int computeCheckDigit(int sum) {
        int modulus = sum % 11;
        if (modulus != 0) {
            return 11 - modulus;
        }
        return 0;
    }
}

