/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.shared.checkdigitformulas;

import java.util.regex.Pattern;

public class ModElevenDashTwoFormula {
    private static final Pattern NON_DIGIT_CHARS_PATTERN = Pattern.compile("[^\\d]");
    private static final int MOD = 11;

    public Integer generateCheckDigit(String input) {
        char[] sanitizedInput = this.removeInvalidCharacters(input);
        int sum = this.getSum(sanitizedInput);
        return this.computeCheckDigit(sum);
    }

    private char[] removeInvalidCharacters(String input) {
        return NON_DIGIT_CHARS_PATTERN.matcher(input).replaceAll("").toCharArray();
    }

    private int getSum(char[] input) {
        int sum = 0;
        for (char c : input) {
            int digit = Character.getNumericValue(c);
            sum = (sum + digit) * 2;
        }
        return sum;
    }

    private int computeCheckDigit(int sum) {
        int remainder = sum % 11;
        return (12 - remainder) % 11;
    }
}

