/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.shared.checkdigitformulas;

import java.util.regex.Pattern;

public class LuhnFormula {
    private static final Pattern NON_DIGIT_CHARS_PATTERN = Pattern.compile("[^\\d]");

    public String generateCheckDigit(String input) {
        char[] sanitizedInput = this.removeInvalidCharacters(input);
        int sum = this.getSum(sanitizedInput);
        return String.valueOf(this.generateCheckDigit(sum));
    }

    private char[] removeInvalidCharacters(String input) {
        return NON_DIGIT_CHARS_PATTERN.matcher(input).replaceAll("").toCharArray();
    }

    private int getSum(char[] chars) {
        int sum = 0;
        for (int i = 0; i < chars.length; ++i) {
            int number = this.getInReverseOrder(chars, i);
            sum += this.getElementValue(i, number);
        }
        return sum;
    }

    private int getInReverseOrder(char[] chars, int i) {
        int position = chars.length - 1 - i;
        char character = chars[position];
        return Character.getNumericValue(character);
    }

    private int getElementValue(int i, int number) {
        if (this.indexIsEven(i)) {
            return this.getOddElementValue(number);
        }
        return number;
    }

    private boolean indexIsEven(int i) {
        return i % 2 == 0;
    }

    private int getOddElementValue(int element) {
        int value = element * 2;
        if (value <= 9) {
            return value;
        }
        return value - 9;
    }

    private int generateCheckDigit(int sum) {
        int modulo = sum % 10;
        if (modulo == 0) {
            return 0;
        }
        return 10 - modulo;
    }
}

